package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;

/**
 * Signals the PLC to take an exposure.
 * @author tether
 */
public class TakeExposure extends MsgToPLC {

    private final Duration exposureTime;

    /** Constructs from scratch. */
    public TakeExposure(Duration exposureTime) {
        this.exposureTime = exposureTime;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data Holds the PLC message data.
     */
    public TakeExposure(final ByteBuffer data) {
        super(data);
        this.exposureTime = Duration.ofMillis(data.getInt());
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt( (int)exposureTime.toMillis());
    }

    @Override
    public String toString() {
        return "TakeExposure{" + super.toString() + " exposureTime=" + exposureTime + '}';
    }

}
