/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.HomeAxisPLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Maint;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Still
extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Still.class.getName());

    public Still(Maint context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((Maint)this.getContext()).getActions().setSoftwareState(SoftwareState.STILL);
    }

    @Override
    public void enableAllAxes(Channel<EventReply> chan, EnableAllAxes req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for enableAllAxes() event."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new EnableAllAxesPLC(req));
        }
    }

    @Override
    public void disableAllAxes(Channel<EventReply> chan, DisableAllAxes req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for disableAllAxes() event."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new DisableAllAxesPLC(req));
        }
    }

    @Override
    public void clearAxisFaults(Channel<EventReply> chan, ClearAxisFaults req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for clearAxisFaults() event."));
        } else if (Axis.fromName((String)req.getAxisName()) == null) {
            chan.write(Still.badAxisReply(req.getAxisName()));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new ClearAxisFaultsPLC(req));
        }
    }

    @Override
    public void changeAxisEnable(Channel<EventReply> chan, ChangeAxisEnable req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for changeAxisEnable() event."));
        } else if (Axis.fromName((String)req.getAxisName()) == null) {
            chan.write(Still.badAxisReply(req.getAxisName()));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new ChangeAxisEnablePLC(req));
        }
    }

    @Override
    public void changeBrakeState(Channel<EventReply> chan, Axis ax, ChangeBrakeState.State newState) throws InterruptedException {
        Logging.logEvent(this);
        if (ax == null || newState == null) {
            chan.write(new PromptReply("The axis or the new brake state is null."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            ((Maint)this.getContext()).getActions().relay(new ChangeBrakeState(ax, newState));
        }
    }

    @Override
    public void clearAllFaults(Channel<EventReply> chan, ClearAllFaults req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for clearAllFaults() event."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new ClearAllFaultsPLC(req));
        }
    }

    @Override
    public void moveAxisRelative(Channel<EventReply> chan, MoveAxisRelative req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for moveAxisRelative() event."));
        } else if (Axis.fromName((String)req.getAxisName()) == null) {
            chan.write(Still.badAxisReply(req.getAxisName()));
        } else if (req.getTime().isNegative() || req.getTime().isZero()) {
            chan.write(new PromptReply("Move time must be greater than zero."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.makeTransition(ctx.getMovingState(), () -> ctx.getActions().relay(new MoveAxisRelativePLC(req)));
        }
    }

    @Override
    public void moveAxisAbsolute(Channel<EventReply> chan, MoveAxisAbsolute req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for moveAxisAbsolute() event."));
        } else if (Axis.fromName((String)req.getAxisName()) == null) {
            chan.write(Still.badAxisReply(req.getAxisName()));
        } else if (req.getSpeed() <= 0.0) {
            chan.write(new PromptReply("Move speed must be greater than zero."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.makeTransition(ctx.getMovingState(), () -> ctx.getActions().relay(new MoveAxisAbsolutePLC(req)));
        }
    }

    @Override
    public void homeAxis(Channel<EventReply> chan, HomeAxis req) throws InterruptedException {
        Logging.logEvent(this);
        if (req == null) {
            chan.write(new PromptReply("Null argument for homeAxis() event."));
        } else if (Axis.fromName((String)req.getAxisName()) == null) {
            chan.write(Still.badAxisReply(req.getAxisName()));
        } else {
            chan.write(PromptReply.ACCEPTED);
            Maint ctx = (Maint)this.getContext();
            ctx.makeTransition(ctx.getMovingState(), () -> ctx.getActions().relay(new HomeAxisPLC(req)));
        }
    }

    @Override
    public void gotoCenter(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        Maint ctx = (Maint)this.getContext();
        ctx.makeTransition(ctx.getCentering1State(), () -> ctx.getActions().startFirstCentering());
    }

    @Override
    public void calibrate(Channel<EventReply> chan, Calibrate calibParams) throws InterruptedException {
        Logging.logEvent(this);
        Maint ctx = (Maint)this.getContext();
        if (calibParams == null) {
            chan.write(new PromptReply("Null parameter for calibrate() event."));
        } else if (ctx.getActions().readyForCalibration()) {
            chan.write(PromptReply.ACCEPTED);
            ctx.makeTransition(ctx.getCalibratingState(), () -> ctx.getActions().relay(calibParams));
        } else {
            chan.write(new PromptReply("Not ready for calibration. See the log."));
        }
    }

    private static PromptReply badAxisReply(String bad) {
        String valid = Stream.of(Axis.values()).map(ax -> "'" + ax.getName() + "'").collect(Collectors.joining(", "));
        return new PromptReply(String.format("Bad axis name '%s'. Valid names: %s.", bad, valid));
    }
}

