/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;

public class Commands
extends Subsystem
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(Commands.class.getName());
    private static final int COMMAND_TIMEOUT = 30;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile StateMachine machine;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Publisher publish;
    private final Channel<EventReply> replyChan = new SynchronousChannel<EventReply>();

    public Commands() {
        super("commands", AgentInfo.AgentType.WORKER);
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty("motorplatform.type", MotorplatformType.SHUTTER.name());
    }

    public String vetoTransitionToNormalMode() {
        try {
            this.machine.gotoProd(this.replyChan);
            EventReply reply = this.replyChan.read();
            if (reply.wasAccepted(null)) {
                return null;
            }
            return reply.getMessage();
        }
        catch (InterruptedException interruptedException) {
            LOG.warning("Unexpected interruption.");
            Thread.currentThread().interrupt();
            return "Unexpected interruption.";
        }
        catch (TimeoutException timeoutException) {
            LOG.warning("Unexpected timeout.");
            return "Unexpected timeout.";
        }
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Try again to sync with the shutter.", timeout=30)
    public void resync() throws InterruptedException {
        this.machine.resync(this.replyChan);
        this.getStateMachineReply();
    }

    private void getStateMachineReply() throws InterruptedException {
        try {
            EventReply reply = this.replyChan.read();
            if (reply.wasAccepted(null)) {
                this.subsys.sendAck(null);
            } else {
                this.subsys.sendNack((Serializable)((Object)reply.getMessage()));
            }
        }
        catch (TimeoutException exc) {
            this.subsys.sendNack((Serializable)((Object)"Timeout inside the subsystem."));
        }
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="Start a calibration.", timeout=30)
    public void calibrate() throws InterruptedException {
        this.machine.calibrate(this.replyChan, new Calibrate());
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Take an exposure for a given number of seconds.", timeout=30)
    public void takeExposure(double exposureTime) throws InterruptedException {
        long millis = Math.round(exposureTime * 1000.0);
        this.machine.takeExposure(this.replyChan, Duration.ofMillis(millis));
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Open the shutter.", timeout=30)
    public void openShutter() throws InterruptedException {
        this.machine.openShutter(this.replyChan);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Close the shutter, aborting any exposure.", timeout=30)
    public void closeShutter() throws InterruptedException {
        this.machine.closeShutter(this.replyChan);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="Change the brake state on an axis.", timeout=30)
    public void changeBrakeState(String axisName, boolean brakeEngaged) throws InterruptedException {
        Axis ax = Axis.fromName((String)axisName);
        if (ax == null) {
            this.subsys.sendNack((Serializable)((Object)"Invalid axis name, use '+X' or '-X'."));
        } else {
            this.machine.changeBrakeState(this.replyChan, ax, brakeEngaged ? ChangeBrakeState.State.ENGAGED : ChangeBrakeState.State.RELEASED);
            this.getStateMachineReply();
        }
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="Center the blades (power-off prep).", timeout=30)
    public void gotoCenter() throws InterruptedException {
        this.machine.gotoCenter(this.replyChan);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start an axis homing.", timeout=30)
    public void homeAxis(HomeAxis req) throws InterruptedException {
        this.machine.homeAxis(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start a move to absolute position.", timeout=30)
    public void moveAxisAbsolute(MoveAxisAbsolute req) throws InterruptedException {
        this.machine.moveAxisAbsolute(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start a position change.", timeout=30)
    public void moveAxisRelative(MoveAxisRelative req) throws InterruptedException {
        this.machine.moveAxisRelative(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Clear faults on both axes.", timeout=30)
    public void clearAllFaults(ClearAllFaults req) throws InterruptedException {
        this.machine.clearAllFaults(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Enable/disable axis.", timeout=30)
    public void changeAxisEnable(ChangeAxisEnable req) throws InterruptedException {
        this.machine.changeAxisEnable(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Clear faults for one axis.", timeout=30)
    public void clearAxisFaults(ClearAxisFaults req) throws InterruptedException {
        this.machine.clearAxisFaults(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Enable both axes.", timeout=30)
    public void enableAllAxes(EnableAllAxes req) throws InterruptedException {
        this.machine.enableAllAxes(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Disable both axes.", timeout=30)
    public void disableAllAxes(DisableAllAxes req) throws InterruptedException {
        this.machine.disableAllAxes(this.replyChan, req);
        this.getStateMachineReply();
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="(Scripting) Emergency stop motion.", timeout=30)
    public void stopAllMotion(StopAllMotion req) throws InterruptedException {
        this.machine.reset(this.replyChan);
        this.getStateMachineReply();
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish controller status ASAP.", timeout=30)
    public void sendControllerStatus(SendControllerStatus cmd) {
        this.publish.publishControllerStatus();
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish controller configuration ASAP.", timeout=30)
    public void sendConfiguration(SendConfiguration cmd) {
        this.publish.publishConfiguration();
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish axis status ASAP.", timeout=30)
    public void sendAxisStatus(SendAxisStatus cmd) {
        this.publish.publishAxisStatus(cmd.getAxisName());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Clear faults on both axes.", timeout=30)
    public void clearFaults() throws InterruptedException {
        this.clearAllFaults(new ClearAllFaults());
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="(Console) Emergeny stop motion.", timeout=30)
    public void stopAll() throws InterruptedException {
        this.stopAllMotion(new StopAllMotion());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Enable an axis.", timeout=30)
    public void enable(String axisName) throws InterruptedException {
        this.changeAxisEnable(new ChangeAxisEnable(axisName, true));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Disable an axis.", timeout=30)
    public void disable(String axisName) throws InterruptedException {
        this.changeAxisEnable(new ChangeAxisEnable(axisName, false));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start an axis homing.", timeout=30)
    public void home(String axisName) throws InterruptedException {
        this.homeAxis(new HomeAxis(axisName));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start a move to an absolute position.", timeout=30)
    public void moveTo(String axisName, double newPositionMm, double speedMmSec) throws InterruptedException {
        this.moveAxisAbsolute(new MoveAxisAbsolute(axisName, newPositionMm, speedMmSec));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start a position change.", timeout=30)
    public void moveBy(String axisName, double positionChangeMm, double seconds) throws InterruptedException {
        this.moveAxisRelative(new MoveAxisRelative(axisName, positionChangeMm, Duration.ofMillis((long)Math.rint(seconds * 1000.0))));
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Console) Show status info for an axis.", timeout=30)
    public String status(String axisName) {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("Axis %s%n");
        buff.append("Enabled %s, Moving %s, At Home %s, At Low %s, At High %s%n");
        buff.append("Position %6.1f%n");
        AxisStatus axstat = this.publish.getAxisStatus(axisName);
        if (axstat == null) {
            return "Not available at present.";
        }
        for (String fault : axstat.getFaults()) {
            buff.append(fault);
            buff.append("%n");
        }
        return String.format(buff.toString(), axstat.getAxisName(), axstat.isEnabled(), axstat.isMoving(), axstat.isAtHome(), axstat.isAtLowLimit(), axstat.isAtHighLimit(), axstat.getPosition());
    }
}

