/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.antlr.AnalyzingParser;
import org.python.antlr.base.mod;
import org.python.antlr.runtime.ANTLRFileStream;
import org.python.antlr.runtime.ANTLRStringStream;
import org.python.antlr.runtime.CharStream;
import org.python.antlr.runtime.RecognitionException;
import org.python.indexer.AstConverter;
import org.python.indexer.Diagnostic;
import org.python.indexer.Indexer;
import org.python.indexer.Util;
import org.python.indexer.ast.NModule;

public class AstCache {
    public static final String CACHE_DIR = new File(Util.getSystemTempDir(), "jython/ast_cache").getAbsolutePath() + File.separator;
    private static final Logger LOG = Logger.getLogger(AstCache.class.getCanonicalName());
    private Map<String, NModule> cache = new HashMap<String, NModule>();
    private static AstCache INSTANCE;

    private AstCache() throws Exception {
        File f = new File(CACHE_DIR);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static AstCache get() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new AstCache();
        }
        return INSTANCE;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean clearDiskCache() {
        try {
            File dir = new File(CACHE_DIR);
            for (File f : dir.listFiles()) {
                if (!f.isFile()) continue;
                f.delete();
            }
            return true;
        }
        catch (Exception x) {
            this.severe("Failed to clear disk cache: " + x);
            return false;
        }
    }

    public NModule getAST(String path) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        return this.fetch(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NModule getAST(String path, String contents) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (contents == null) {
            throw new IllegalArgumentException("null contents");
        }
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        NModule mod2 = null;
        try {
            mod2 = this.parse(path, contents);
            if (mod2 != null) {
                mod2.setFileAndMD5(path, Util.getMD5(contents.getBytes("UTF-8")));
            }
        }
        finally {
            this.cache.put(path, mod2);
        }
        return mod2;
    }

    private NModule fetch(String path) throws Exception {
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        NModule mod2 = this.getSerializedModule(path);
        if (mod2 != null) {
            this.fine("reusing " + path);
            this.cache.put(path, mod2);
            return mod2;
        }
        try {
            mod2 = this.parse(path);
        }
        finally {
            this.cache.put(path, mod2);
        }
        if (mod2 != null) {
            this.serialize(mod2);
        }
        return mod2;
    }

    private NModule parse(String path) throws Exception {
        this.fine("parsing " + path);
        mod ast2 = this.invokeANTLR(path);
        return this.generateAST(ast2, path);
    }

    private NModule parse(String path, String contents) throws Exception {
        this.fine("parsing " + path);
        mod ast2 = this.invokeANTLR(path, contents);
        return this.generateAST(ast2, path);
    }

    private NModule generateAST(mod ast2, String path) throws Exception {
        if (ast2 == null) {
            Indexer.idx.reportFailedAssertion("ANTLR returned NULL for " + path);
            return null;
        }
        Object obj = ast2.accept(new AstConverter());
        if (!(obj instanceof NModule)) {
            this.warn("\n[warning] converted AST is not a module: " + obj);
            return null;
        }
        NModule module = (NModule)obj;
        if (new File(path).canRead()) {
            module.setFile(path);
        }
        return module;
    }

    private mod invokeANTLR(String filename) {
        ANTLRFileStream text2 = null;
        try {
            text2 = new ANTLRFileStream(filename);
        }
        catch (IOException iox) {
            this.fine(filename + ": " + iox);
            return null;
        }
        return this.invokeANTLR(text2, filename);
    }

    private mod invokeANTLR(String filename, String contents) {
        ANTLRStringStream text2 = new ANTLRStringStream(contents);
        return this.invokeANTLR(text2, filename);
    }

    private mod invokeANTLR(CharStream text2, String filename) {
        AnalyzingParser p = new AnalyzingParser(text2, filename, null);
        mod ast2 = null;
        try {
            ast2 = p.parseModule();
        }
        catch (Exception x) {
            this.fine("parse for " + filename + " failed: " + x);
        }
        this.recordParseErrors(filename, p.getRecognitionErrors());
        return ast2;
    }

    private void recordParseErrors(String path, List<RecognitionException> errs) {
        if (errs.isEmpty()) {
            return;
        }
        List<Diagnostic> diags = Indexer.idx.getParseErrs(path);
        for (RecognitionException rx : errs) {
            String msg = rx.line + ":" + rx.charPositionInLine + ":" + rx;
            diags.add(new Diagnostic(path, Diagnostic.Type.ERROR, -1, -1, msg));
        }
    }

    public String getCachePath(File sourcePath) throws Exception {
        return this.getCachePath(Util.getMD5(sourcePath), sourcePath.getName());
    }

    public String getCachePath(String md52, String name) {
        return CACHE_DIR + name + md52 + ".ast";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialize(NModule ast2) throws Exception {
        String path = this.getCachePath(ast2.getMD5(), new File(ast2.getFile()).getName());
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(ast2);
        }
        finally {
            if (oos != null) {
                oos.close();
            } else if (fos != null) {
                fos.close();
            }
        }
    }

    NModule getSerializedModule(String sourcePath) {
        try {
            File sourceFile = new File(sourcePath);
            if (sourceFile == null || !sourceFile.canRead()) {
                return null;
            }
            File cached = new File(this.getCachePath(sourceFile));
            if (!cached.canRead()) {
                return null;
            }
            return this.deserialize(sourceFile);
        }
        catch (Exception x) {
            this.severe("Failed to deserialize " + sourcePath + ": " + x);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NModule deserialize(File sourcePath) throws Exception {
        String cachePath = this.getCachePath(sourcePath);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(cachePath);
            ois = new ObjectInputStream(fis);
            NModule mod2 = (NModule)ois.readObject();
            mod2.setFile(sourcePath);
            NModule nModule = mod2;
            return nModule;
        }
        finally {
            if (ois != null) {
                ois.close();
            } else if (fis != null) {
                fis.close();
            }
        }
    }

    private void log(Level level, String msg) {
        if (LOG.isLoggable(level)) {
            LOG.log(level, msg);
        }
    }

    private void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    private void warn(String msg) {
        this.log(Level.WARNING, msg);
    }

    private void info(String msg) {
        this.log(Level.INFO, msg);
    }

    private void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    private void finer(String msg) {
        this.log(Level.FINER, msg);
    }
}

