/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.Maint;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MaintTest {
    @Test
    public void testTransitions() throws InterruptedException {
        Enabled dummyContext = (Enabled)Mockito.mock(Enabled.class);
        Actions mockActions = (Actions)Mockito.mock(Actions.class);
        Maint sm = new Maint(mockActions, dummyContext);
        DummyChannel chan = new DummyChannel();
        sm.init();
        sm.changeAxisEnable(chan, new ChangeAxisEnable(Axis.AXIS0.getName(), true));
        sm.clearAllFaults(chan, new ClearAllFaults());
        sm.clearAxisFaults(chan, new ClearAxisFaults(Axis.AXIS0.getName()));
        sm.disableAllAxes(chan, new DisableAllAxes());
        sm.enableAllAxes(chan, new EnableAllAxes());
        sm.changeBrakeState(chan, Axis.AXIS0, ChangeBrakeState.State.RELEASED);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.moveAxisAbsolute(chan, new MoveAxisAbsolute(Axis.AXIS0.getName(), 0.0, 100.0));
        ((Actions)Mockito.verify((Object)mockActions)).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions)).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions)).setSoftwareState(SoftwareState.MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        MotionDonePLC md1 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(chan, md1);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.moveAxisRelative(chan, new MoveAxisRelative(Axis.AXIS0.getName(), 100.0, Duration.ofSeconds(10L)));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        MotionDonePLC md2 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(chan, md2);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)5))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        Mockito.when((Object)mockActions.readyForCalibration()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        sm.calibrate(chan, (Calibrate)Mockito.mock(Calibrate.class));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)0))).setSoftwareState(SoftwareState.CALIBRATING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)5))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.calibrate(chan, (Calibrate)Mockito.mock(Calibrate.class));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)5))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CALIBRATING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)6))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.calibDone(chan, (CalibDone)Mockito.mock(CalibDone.class));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)6))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)7))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.gotoCenter(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)7))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CENTERING1);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)8))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        MotionDonePLC md3 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(chan, md3);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CENTERING2);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)9))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        MotionDonePLC md4 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(chan, md4);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CENTERED);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)8))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)5))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)10))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{dummyContext, md1, md2, md3, md4});
        InOrder order = Mockito.inOrder((Object[])new Object[]{mockActions});
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ChangeAxisEnablePLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ClearAllFaultsPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ClearAxisFaultsPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(DisableAllAxesPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(EnableAllAxesPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ChangeBrakeState.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(MoveAxisAbsolutePLC.class));
        ((Actions)order.verify((Object)mockActions)).sendProfile(md1);
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(MoveAxisRelativePLC.class));
        ((Actions)order.verify((Object)mockActions)).sendProfile(md2);
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(Calibrate.class));
        ((Actions)order.verify((Object)mockActions)).saveCalib((CalibDone)ArgumentMatchers.any(CalibDone.class));
        ((Actions)order.verify((Object)mockActions)).startFirstCentering();
        ((Actions)order.verify((Object)mockActions)).sendProfile(md3);
        ((Actions)order.verify((Object)mockActions)).startSecondCentering();
        ((Actions)order.verify((Object)mockActions)).sendProfile(md4);
        ((Actions)order.verify((Object)mockActions, Mockito.atLeast((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)order.verify((Object)mockActions, Mockito.atLeast((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        order.verifyNoMoreInteractions();
    }
}

