/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.CompositeState;
import org.lsst.ccs.subsystem.shutter.statemachine.Disabled;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.State;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;

class InSync
extends CompositeState<InSync, TopContext> {
    private static final Logger LOG = Logger.getLogger(InSync.class.getName());
    private Enabled enabledState;
    private Disabled disabledState;

    InSync(Actions actions, TopContext context) {
        super(actions, context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    synchronized Enabled getEnabledState() {
        if (this.enabledState == null) {
            this.enabledState = new Enabled(this.getActions(), this);
        }
        return this.enabledState;
    }

    synchronized Disabled getDisabledState() {
        if (this.disabledState == null) {
            this.disabledState = new Disabled(this);
        }
        return this.disabledState;
    }

    @Override
    public void init() {
        State<InSync> initState = ((TopContext)this.getContext()).getPLCEnabled() ? this.getEnabledState() : this.getDisabledState();
        this.makeTransition(initState, null);
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((TopContext)this.getContext()).getActions().lowerSyncAlert();
        ((TopContext)this.getContext()).getActions().makeFullContact();
        this.init();
    }

    @Override
    public void contactLost(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getSyncErrorState(), null);
    }

    @Override
    public void ignored(Channel<EventReply> chan, Ignored.Reason reason) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        LOG.warning(() -> String.format("The shutter controller sent the ignored(%s) event.", new Object[]{reason}));
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getSyncErrorState(), null);
    }
}

