/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.Controller;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.RealActions;
import org.lsst.ccs.subsystem.shutter.SimulatedActions;
import org.lsst.ccs.subsystem.shutter.SoftwareStateOwner;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Events;
import org.lsst.ccs.subsystem.shutter.statemachine.FutureReply;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class StateMachine
implements HasLifecycle,
Events {
    private static final Logger LOG = Logger.getLogger((String)StateMachine.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Controller controller;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Publisher publish;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile SoftwareStateOwner softstate;
    @ConfigurationParameter(isFinal=true, description="How long to delay restarting a crashed event task.")
    private volatile Duration taskRestartDelay = Duration.ofMillis(10L);
    @ConfigurationParameter(isFinal=true, description="Wait this long for the shutter to enter Still or Disabled after a reset.")
    private volatile Duration resetSyncTimeout = Duration.ofSeconds(10L);
    private final PriorityBlockingQueue<DeferredEvent> eventQueue = new PriorityBlockingQueue();
    private final Scheduler eventTaskScheduler = new Scheduler("State machine events", 3);
    private volatile PeriodicTask eventTask;
    private volatile ScheduledFuture<?> syncTimeoutTask;
    private volatile TopContext machine;
    private volatile Actions actions;

    public StateMachine() {
        this.eventTaskScheduler.setLogger(LOG);
        this.eventTaskScheduler.setDefaultLogLevel(Level.SEVERE);
    }

    public void init() {
        AgentStateService stateServ = (AgentStateService)this.subsys.getAgentService(AgentStateService.class);
        stateServ.registerState(PhysicalState.class, "The physical state of the shutter", (Object)this);
        stateServ.updateAgentComponentState((Object)this, new Enum[]{PhysicalState.OTHER});
    }

    public void postStart() {
        if (RunMode.isSimulation()) {
            this.actions = new SimulatedActions(this.controller, this, this.subsys, this.publish);
            this.machine = new TopContext(this.actions);
        } else {
            this.actions = new RealActions(this.controller, this, this.subsys, this.publish);
            this.machine = new TopContext(this.actions);
        }
        this.machine.init();
        this.eventTask = this.eventTaskScheduler.scheduleWithFixedDelay(this::eventTaskBody, 0L, this.taskRestartDelay.toMillis(), TimeUnit.MILLISECONDS);
        if (RunMode.isSimulation()) {
            this.plcIsEnabled();
            this.gotoProd();
        }
    }

    public Actions getActions() {
        return this.actions;
    }

    private void eventTaskBody() {
        LOG.info((Object)"The event task has started.");
        try {
            while (true) {
                LOG.info((Object)"About to dequeue event.");
                DeferredEvent event = this.eventQueue.take();
                LOG.info((Object)"Dequeueing event.");
                event.run();
            }
        }
        catch (InterruptedException exc) {
            LOG.info((Object)"Normal stop of the event task.");
            return;
        }
    }

    public void shutdown() {
        this.eventTaskScheduler.shutdownNow();
    }

    private EventReply defer(Priority eventPriority, Supplier<EventReply> event) {
        FutureReply reply = new FutureReply();
        LOG.info((Object)"About to add to event queue.");
        this.eventQueue.add(new DeferredEvent(eventPriority, reply, event));
        return reply;
    }

    @Override
    public EventReply contactLost() {
        return this.defer(Priority.HIGH, () -> this.machine.contactLost());
    }

    @Override
    public EventReply plcIsEnabled() {
        return this.defer(Priority.HIGH, () -> this.machine.plcIsEnabled());
    }

    @Override
    public EventReply plcIsDisabled() {
        return this.defer(Priority.HIGH, () -> this.machine.plcIsDisabled());
    }

    @Override
    public EventReply resync() {
        return this.defer(Priority.LOW, () -> this.machine.resync());
    }

    @Override
    public EventReply syncTimeout() {
        return this.defer(Priority.HIGH, () -> this.machine.syncTimeout());
    }

    @Override
    public EventReply enable() {
        return this.defer(Priority.HIGH, () -> this.machine.enable());
    }

    @Override
    public EventReply disable() {
        return this.defer(Priority.HIGH, () -> this.machine.disable());
    }

    @Override
    public EventReply motionDone(MotionDonePLC profileData) {
        return this.defer(Priority.HIGH, () -> this.machine.motionDone(profileData));
    }

    @Override
    public EventReply calibrate(Calibrate calibParams) {
        return this.defer(Priority.LOW, () -> this.machine.calibrate(calibParams));
    }

    @Override
    public EventReply calibDone(CalibDone calibResults) {
        return this.defer(Priority.HIGH, () -> this.machine.calibDone(calibResults));
    }

    @Override
    public EventReply error() {
        return this.defer(Priority.HIGH, () -> this.machine.error());
    }

    @Override
    public EventReply reset() {
        return this.defer(Priority.HIGH, () -> this.machine.reset());
    }

    @Override
    public EventReply takeExposure(Duration exposureTime) {
        return this.defer(Priority.LOW, () -> this.machine.takeExposure(exposureTime));
    }

    @Override
    public EventReply openShutter() {
        return this.defer(Priority.LOW, () -> this.machine.openShutter());
    }

    @Override
    public EventReply timer() {
        return this.defer(Priority.HIGH, () -> this.machine.timer());
    }

    @Override
    public EventReply closeShutter() {
        return this.defer(Priority.LOW, () -> this.machine.closeShutter());
    }

    @Override
    public EventReply ignored(Ignored.Reason reason) {
        return this.defer(Priority.HIGH, () -> this.machine.ignored(reason));
    }

    @Override
    public EventReply gotoProd() {
        return this.defer(Priority.LOW, () -> this.machine.gotoProd());
    }

    @Override
    public EventReply gotoCenter() {
        return this.defer(Priority.LOW, () -> this.machine.gotoCenter());
    }

    @Override
    public EventReply moveAxisAbsolute(MoveAxisAbsolute req) {
        return this.defer(Priority.LOW, () -> this.machine.moveAxisAbsolute(req));
    }

    @Override
    public EventReply moveAxisRelative(MoveAxisRelative req) {
        return this.defer(Priority.LOW, () -> this.machine.moveAxisRelative(req));
    }

    @Override
    public EventReply clearAllFaults(ClearAllFaults req) {
        return this.defer(Priority.LOW, () -> this.machine.clearAllFaults(req));
    }

    @Override
    public EventReply changeAxisEnable(ChangeAxisEnable req) {
        return this.defer(Priority.LOW, () -> this.machine.changeAxisEnable(req));
    }

    @Override
    public EventReply changeBrakeState(Axis ax, ChangeBrakeState.State newState) {
        return this.defer(Priority.LOW, () -> this.machine.changeBrakeState(ax, newState));
    }

    @Override
    public EventReply clearAxisFaults(ClearAxisFaults req) {
        return this.defer(Priority.LOW, () -> this.machine.clearAxisFaults(req));
    }

    @Override
    public EventReply enableAllAxes(EnableAllAxes req) {
        return this.defer(Priority.LOW, () -> this.machine.enableAllAxes(req));
    }

    @Override
    public EventReply disableAllAxes(DisableAllAxes req) {
        return this.defer(Priority.LOW, () -> this.machine.disableAllAxes(req));
    }

    void setPhysicalState(PhysicalState newState) {
        AgentStateService stateServ = (AgentStateService)this.subsys.getAgentService(AgentStateService.class);
        stateServ.updateAgentComponentState((Object)this, new Enum[]{newState});
    }

    void setSoftwareState(SoftwareState newState) {
        AgentStateService stateServ = (AgentStateService)this.subsys.getAgentService(AgentStateService.class);
        stateServ.updateAgentComponentState((Object)this.softstate, new Enum[]{newState});
    }

    synchronized void startSyncTimer() {
        this.syncTimeoutTask = this.eventTaskScheduler.schedule(() -> this.syncTimeout(), this.resetSyncTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    synchronized void cancelSyncTimer() {
        if (this.syncTimeoutTask != null) {
            this.syncTimeoutTask.cancel(true);
        }
    }

    private static class DeferredEvent
    implements Comparable<DeferredEvent>,
    Runnable {
        private final Priority prio;
        private final FutureReply reply;
        private final Supplier<EventReply> event;

        DeferredEvent(Priority prio, FutureReply reply, Supplier<EventReply> event) {
            this.prio = Objects.requireNonNull(prio);
            this.reply = Objects.requireNonNull(reply);
            this.event = Objects.requireNonNull(event);
        }

        @Override
        public int compareTo(DeferredEvent o) {
            return this.prio.compareTo(Objects.requireNonNull(o).prio);
        }

        @Override
        public void run() {
            this.reply.put(this.event.get());
        }
    }

    private static enum Priority {
        HIGH,
        LOW;

    }
}

