/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.Controller;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.logging.Logger;

public class SimulatedActions
implements Actions {
    private static final Logger LOG = Logger.getLogger((String)SimulatedActions.class.getName());
    private static final Alert SYNC_ALERT = new Alert("SYNC", "Status of tracking of controller state.");
    private final Controller control;
    private final StateMachine machine;
    private final Subsystem subsys;
    private final Publisher publish;

    public SimulatedActions(Controller control, StateMachine machine, Subsystem subsys, Publisher publish) {
        this.control = control;
        this.machine = machine;
        this.subsys = subsys;
        this.publish = publish;
    }

    @Override
    public void cancelSyncTimer() {
        LOG.info((Object)"{ACTION cancelSyncTimer()}");
    }

    @Override
    public boolean isBadExposureTime(Duration exposureTime) {
        LOG.info((Object)"{ACTION isBadExposure()}");
        return false;
    }

    @Override
    public void lowerSyncAlert() {
        LOG.info((Object)"{ACTION lowerSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.NOMINAL, "OK.");
    }

    @Override
    public boolean makePartialContact() {
        LOG.info((Object)"{ACTION makePartialContact()}");
        this.control.simulateContact();
        return true;
    }

    @Override
    public boolean makeFullContact() {
        LOG.info((Object)"{ACTION makeFullContact()}");
        return true;
    }

    @Override
    public void publishEnableStatus(boolean isEnabled) {
        this.publish.setEnableStatus(isEnabled);
    }

    @Override
    public void setPhysicalState(PhysicalState newState) {
        LOG.info((Object)String.format("{ACTION setPhysicalState(%s)}", new Object[]{newState}));
        this.machine.setPhysicalState(newState);
    }

    @Override
    public void setSoftwareState(SoftwareState newState) {
        LOG.info((Object)String.format("{ACTION setSoftwareState(%s)}", new Object[]{newState}));
        this.machine.setSoftwareState(newState);
    }

    @Override
    public void raiseSyncAlert() {
        LOG.info((Object)"{ACTION raiseSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.ALARM, "Lost track.");
    }

    @Override
    public boolean readyForCalibration() {
        LOG.info((Object)"{ACTION readyForCalibration()}");
        return true;
    }

    @Override
    public void resetPLC() {
        LOG.info((Object)"{ACTION resetPLC()}");
        this.control.simulateResetPLC();
    }

    @Override
    public void relay(MsgToPLC eventMsg) {
        LOG.log(Level.INFO, "'{'ACTION relay({0})'}'", eventMsg.getClass());
        this.control.simulateRelay(eventMsg);
    }

    @Override
    public void saveCalib(CalibDone cal) {
        LOG.info((Object)"{ACTION saveCalib() - not yet implemented.}");
    }

    @Override
    public void sendProfile(MotionDonePLC mot) {
        LOG.info((Object)"{ACTION sendProfile()}");
        this.dumpMotionDone(mot.getStatusBusMessage());
        this.publish.publishMotionDone(mot.getStatusBusMessage());
    }

    private void dumpMotionDone(MotionDone mot) {
        StringBuilder bld = new StringBuilder();
        bld.append("[MotionDone begin]\n");
        bld.append("side " + (Object)((Object)mot.side()) + "\n");
        bld.append("startPosition " + mot.startPosition() + " mm\n");
        bld.append("startTime " + mot.startTime().getUTCInstant().toEpochMilli() + " Unix epoch ms\n");
        bld.append("targetPosition " + mot.targetPosition() + " mm\n");
        bld.append("targetDuration " + mot.targetDuration().toMillis() + " ms\n");
        bld.append("endPosition " + mot.endPosition() + " mm\n");
        bld.append("actualDuration " + mot.actualDuration().toMillis() + " ms\n");
        bld.append("[Hall begin] time(Unix epoch ms) ID position(mm) isOn\n");
        for (HallTransition hall : mot.hallTransitions()) {
            bld.append(hall.getTime().getUTCInstant().toEpochMilli());
            bld.append(" ");
            bld.append(hall.getSensorId());
            bld.append(" ");
            bld.append(hall.getPosition());
            bld.append(" ");
            bld.append(hall.isOn());
            bld.append("\n");
        }
        bld.append("[Hall end]\n");
        bld.append("[Encoder begin] time(Unix epoch ms) position(mm)\n");
        for (EncoderSample enc : mot.encoderSamples()) {
            bld.append(enc.getTime().getUTCInstant().toEpochMilli());
            bld.append(" ");
            bld.append(enc.getPosition());
            bld.append("\n");
        }
        bld.append("[Encoder end]\n");
        bld.append("[MotionDone end]\n");
        LOG.fine((Object)bld.toString());
    }

    @Override
    public void startFirstCentering() {
        LOG.info((Object)"{ACTION startFirstCentering()}");
        this.control.startFirstCentering();
    }

    @Override
    public void startSecondCentering() {
        LOG.info((Object)"{ACTION startSecondCentering(};}");
        this.control.startSecondCentering();
    }

    @Override
    public boolean shutterIsReady() {
        LOG.info((Object)"{ACTION shutterIsReady()}");
        return true;
    }

    @Override
    public void startSyncTimer() {
        LOG.info((Object)"{ACTION startSyncTimer()}");
    }

    @Override
    public void terminateContact() {
        LOG.info((Object)"{ACTION terminateContact()}");
    }
}

