package org.lsst.ccs.subsystem.shutter;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;

/**
 * A dummy component which serves as the owner of the {@code SoftwareState} component of the
 * subsystem's state bundle.
 * @author tether
 * @see SoftwareState
 */
public class SoftwareStateOwner implements HasLifecycle {

    /** A reference to the Subsystem component in the subsystem tree. */
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;

    @Override
    public void init() {
        final AgentStateService stateServ = subsys.getAgentService(AgentStateService.class);
        stateServ.registerState(SoftwareState.class, "The state of the internal state machine", this);
        stateServ.updateAgentComponentState(this, SoftwareState.SYNCHRONIZING);
    }
    
}
