/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.CompositeState;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.InSync;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Maint;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;

class Enabled
extends CompositeState<Enabled, InSync> {
    private static final Logger LOG = Logger.getLogger(Enabled.class.getName());
    private Maint maintState;
    private Prod prodState;

    public Enabled(Actions actions, InSync context) {
        super(actions, context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        this.getActions().publishEnableStatus(true);
        this.init();
    }

    @Override
    public void init() {
        this.makeTransition(this.getMaintState(), null);
    }

    @Override
    public void exit() {
        this.getActions().publishEnableStatus(false);
        this.finish();
        Logging.logExit(this);
    }

    synchronized Maint getMaintState() {
        if (this.maintState == null) {
            this.maintState = new Maint(this.getActions(), this);
        }
        return this.maintState;
    }

    synchronized Prod getProdState() {
        if (this.prodState == null) {
            this.prodState = new Prod(this.getActions(), this);
        }
        return this.prodState;
    }

    @Override
    public EventReply disable() {
        Logging.logEvent(this);
        ((InSync)this.getContext()).makeTransition(((InSync)this.getContext()).getDisabledState(), () -> ((InSync)this.getContext()).getActions().setPhysicalState(PhysicalState.OTHER));
        return PromptReply.ACCEPTED;
    }
}

