/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;

public class Main {
    private static final Duration RENDEZVOUS_TIMEOUT = Duration.ofSeconds(3L);
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile StateMachine machine;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Publisher publish;

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Try again to sync with the shutter.")
    public void resync() {
        this.getStateMachineReply(this.machine.resync());
    }

    private void getStateMachineReply(EventReply reply) {
        try {
            if (reply.wasAccepted(RENDEZVOUS_TIMEOUT)) {
                this.subsys.sendAck(null);
            } else {
                this.subsys.sendNack((Serializable)((Object)reply.getMessage()));
            }
        }
        catch (TimeoutException exc) {
            this.subsys.sendNack((Serializable)((Object)"Timeout inside the subsystem."));
        }
        catch (InterruptedException exc) {
            this.subsys.sendNack((Serializable)((Object)"Command was interrupted!"));
        }
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="Start a calibration.")
    public void calibrate() {
        this.getStateMachineReply(this.machine.calibrate(new Calibrate()));
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Take an exposure for a given number of seconds.")
    public void takeExposure(double exposureTime) throws InterruptedException {
        long millis = Math.round(exposureTime * 1000.0);
        this.getStateMachineReply(this.machine.takeExposure(Duration.ofMillis(millis)));
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Open the shutter.")
    public void openShutter() throws InterruptedException {
        this.getStateMachineReply(this.machine.openShutter());
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="Close the shutter, aborting any exposure.")
    public void closeShutter() throws InterruptedException {
        this.getStateMachineReply(this.machine.closeShutter());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="Change the brake state on an axis.")
    public void changeBrakeState(String axisName, boolean brakeEngaged) throws InterruptedException {
        Axis ax = Axis.fromName(axisName);
        if (ax == null) {
            this.subsys.sendNack((Serializable)((Object)"Invalid axis name, use '+X' or '-X'."));
        }
        this.getStateMachineReply(this.machine.changeBrakeState(ax, brakeEngaged ? ChangeBrakeState.State.ENGAGED : ChangeBrakeState.State.RELEASED));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="Enter production (NORMAL) mode.")
    public void gotoProd() throws InterruptedException {
        this.getStateMachineReply(this.machine.gotoProd());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="Center the blades (power-off prep).")
    public void gotoCenter() throws InterruptedException {
        this.getStateMachineReply(this.machine.gotoCenter());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start an axis homing.")
    public void homeAxis(HomeAxis req) throws InterruptedException {
        this.subsys.sendNack((Serializable)((Object)"Axis homing is part of calibration."));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start a move to absolute position.")
    public void moveAxisAbsolute(MoveAxisAbsolute req) throws InterruptedException {
        this.getStateMachineReply(this.machine.moveAxisAbsolute(req));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start a position change.")
    public void moveAxisRelative(MoveAxisRelative req) throws InterruptedException {
        this.getStateMachineReply(this.machine.moveAxisRelative(req));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Clear faults on both axes.")
    public void clearAllFaults(ClearAllFaults req) throws InterruptedException {
        this.getStateMachineReply(this.machine.clearAllFaults(req));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Enable/disable axis.")
    public void changeAxisEnable(ChangeAxisEnable req) throws InterruptedException {
        this.getStateMachineReply(this.machine.changeAxisEnable(req));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Clear faults for one axis.")
    public void clearAxisFaults(ClearAxisFaults req) throws InterruptedException {
        this.getStateMachineReply(this.machine.clearAxisFaults(req));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Enable both axes.")
    public void enableAllAxes(EnableAllAxes req) throws InterruptedException {
        this.getStateMachineReply(this.machine.enableAllAxes(req));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Disable both axes.")
    public void disableAllAxes(DisableAllAxes req) throws InterruptedException {
        this.getStateMachineReply(this.machine.disableAllAxes(req));
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="(Scripting) Emergency stop motion.")
    public void stopAllMotion(StopAllMotion req) throws InterruptedException {
        this.getStateMachineReply(this.machine.reset());
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish controller status ASAP.")
    public void sendControllerStatus(SendControllerStatus cmd) {
        this.publish.publishControllerStatus();
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish controller configuration ASAP.")
    public void sendConfiguration(SendConfiguration cmd) {
        this.publish.publishConfiguration();
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish axis status ASAP.")
    public void sendAxisStatus(SendAxisStatus cmd) {
        this.publish.publishAxisStatus(cmd.getAxisName());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Clear faults on both axes.")
    public void clearFaults() throws InterruptedException {
        this.clearAllFaults(new ClearAllFaults());
    }

    @Command(autoAck=false, level=0, type=Command.CommandType.ACTION, description="(Console) Emergeny stop motion.")
    public void stopAll() throws InterruptedException {
        this.stopAllMotion(new StopAllMotion());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Enable an axis.")
    public void enable(String axisName) throws InterruptedException {
        this.changeAxisEnable(new ChangeAxisEnable(axisName, true));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Disable an axis.")
    public void disable(String axisName) throws InterruptedException {
        this.changeAxisEnable(new ChangeAxisEnable(axisName, false));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start an axis homing.")
    public void home(String axisName) throws InterruptedException {
        this.homeAxis(new HomeAxis(axisName));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start a move to an absolute position.")
    public void moveTo(String axisName, double newPositionMm, double speedMmSec) throws InterruptedException {
        this.moveAxisAbsolute(new MoveAxisAbsolute(axisName, newPositionMm, speedMmSec));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start a position change.")
    public void moveBy(String axisName, double positionChangeMm, double seconds) throws InterruptedException {
        this.moveAxisRelative(new MoveAxisRelative(axisName, positionChangeMm, Duration.ofMillis((long)Math.rint(seconds * 1000.0))));
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Console) Show status info for an axis.")
    public String status(String axisName) {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("Axis %s%n");
        buff.append("Enabled %s, Moving %s, At Home %s, At Low %s, At High %s%n");
        buff.append("Position %6.1f%n");
        AxisStatus axstat = this.publish.getAxisStatus(axisName);
        if (axstat == null) {
            return "Not available at present.";
        }
        for (String fault : axstat.getFaults()) {
            buff.append(fault);
            buff.append("%n");
        }
        return String.format(buff.toString(), axstat.getAxisName(), axstat.isEnabled(), axstat.isMoving(), axstat.isAtHome(), axstat.isAtLowLimit(), axstat.isAtHighLimit(), axstat.getPosition());
    }
}

