/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;

class Synchronizing
extends SimpleState<TopContext> {
    private static final Logger LOG = Logger.getLogger(Synchronizing.class.getName());

    public Synchronizing(TopContext context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((TopContext)this.getContext()).getActions().setSoftwareState(SoftwareState.SYNCHRONIZING);
        boolean contacted = ((TopContext)this.getContext()).getActions().makePartialContact();
        if (contacted) {
            ((TopContext)this.getContext()).getActions().resetPLC();
            ((TopContext)this.getContext()).getActions().startSyncTimer();
        }
    }

    @Override
    public void exit() {
        ((TopContext)this.getContext()).getActions().cancelSyncTimer();
        Logging.logExit(this);
    }

    @Override
    public EventReply plcIsDisabled() {
        Logging.logEvent(this);
        ((TopContext)this.getContext()).setPLCEnabled(false);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getInSyncState(), null);
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply plcIsEnabled() {
        Logging.logEvent(this);
        ((TopContext)this.getContext()).setPLCEnabled(true);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getInSyncState(), null);
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply syncTimeout() {
        Logging.logEvent(this);
        ((TopContext)this.getContext()).setPLCEnabled(false);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getSyncErrorState(), null);
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply contactLost() {
        Logging.logEvent(this);
        ((TopContext)this.getContext()).setPLCEnabled(false);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getSyncErrorState(), null);
        return PromptReply.ACCEPTED;
    }
}

