/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.Objects;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Context;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.State;

abstract class SimpleState<C extends Context<?>>
implements State<C> {
    private final C context;

    protected SimpleState(C context) {
        Objects.requireNonNull(context, "A state's context can't be null.");
        this.context = context;
    }

    @Override
    public final C getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public EventReply contactLost() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply plcIsEnabled() {
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply plcIsDisabled() {
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply resync() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply syncTimeout() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply enable() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply disable() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply motionDone(MotionDonePLC profileData) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply calibrate(Calibrate calibParams) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply calibDone(CalibDone calibResults) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply error() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply reset() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply takeExposure(Duration exposureTime) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply openShutter() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply timer() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply closeShutter() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply ignored(Ignored.Reason reason) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply gotoProd() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply gotoCenter() {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply moveAxisAbsolute(MoveAxisAbsolute req) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply moveAxisRelative(MoveAxisRelative req) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply clearAllFaults(ClearAllFaults req) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply changeAxisEnable(ChangeAxisEnable req) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply clearAxisFaults(ClearAxisFaults req) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply changeBrakeState(Axis ax, ChangeBrakeState.State newState) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply enableAllAxes(EnableAllAxes req) {
        return new PromptReply(this.rejectionMsg());
    }

    @Override
    public EventReply disableAllAxes(DisableAllAxes req) {
        return new PromptReply(this.rejectionMsg());
    }

    protected final String rejectionMsg() {
        return String.format("Event %s() is invalid for CCS state %s.", new Exception().getStackTrace()[1].getMethodName(), this.getName());
    }
}

