/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Maint;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Moving
extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Moving.class.getName());

    public Moving(Maint context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((Maint)this.getContext()).getActions().setSoftwareState(SoftwareState.MOVING);
        ((Maint)this.getContext()).getActions().setPhysicalState(PhysicalState.ENG_MOVING);
    }

    @Override
    public EventReply motionDone(MotionDonePLC profileData) {
        Logging.logEvent(this);
        Maint ctx = (Maint)this.getContext();
        ctx.makeTransition(ctx.getStillState(), () -> {
            ctx.getActions().setPhysicalState(PhysicalState.OTHER);
            ctx.getActions().sendProfile(profileData);
        });
        return PromptReply.ACCEPTED;
    }
}

