/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.shutter.PLCVariableDictionary;
import org.lsst.ccs.subsystem.shutter.SimMessage;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.GoToProd;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.PLCMsg;
import org.lsst.ccs.subsystem.shutter.plc.ShutterStatusPLC;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class SimulatedShutter {
    private static final Logger LOG = Logger.getLogger(SimulatedShutter.class.getName());
    private final Scheduler scheduler;
    private final BlockingQueue<SimMessage> outQueue;
    private final BlockingQueue<MsgToPLC> inQueue;
    private final PLCVariableDictionary dictionary;
    private final Map<ShutterSide, SideInfo> sdinfo;
    private ShutterSide closingSide;

    SimulatedShutter(Scheduler scheduler, BlockingQueue<SimMessage> outQueue, PLCVariableDictionary dictionary) {
        this.scheduler = scheduler;
        this.inQueue = new ArrayBlockingQueue<MsgToPLC>(1000);
        this.outQueue = outQueue;
        this.dictionary = dictionary;
        this.sdinfo = new EnumMap<ShutterSide, SideInfo>(ShutterSide.class);
    }

    void start() {
        LOG.info("Starting controller simulation.");
        this.scheduler.scheduleWithFixedDelay(this::taskBody, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    void accept(MsgToPLC msg) {
        LOG.info(String.format("Accepting message %s.", msg.getClass().getSimpleName()));
        if (!this.inQueue.offer(msg)) {
            LOG.warning("Input queue is full.");
        }
    }

    private void taskBody() {
        this.setInitialPositions();
        this.sendStatus();
        LOG.info("In event loop for simulated shutter.");
        try {
            while (true) {
                MsgToPLC msg;
                PLCVariableDictionary.InVariable var;
                if ((var = this.dictionary.getInVariable((msg = this.inQueue.take()).getClass())) == null) {
                    LOG.warning(String.format("Incoming message %s not in dictionary.", msg.getClass().getName()));
                    continue;
                }
                this.sendMessage(var.ackName, msg);
                this.interpretMessage(msg);
            }
        }
        catch (InterruptedException exc) {
            LOG.info("Normal termination of shutter controller simulation.");
            return;
        }
    }

    private void sendMessage(String varName, PLCMsg msg) {
        LOG.info(String.format("Sending message %s.", msg.getClass().getSimpleName()));
        ByteBuffer data = ByteBuffer.allocate(10240);
        msg.encode(data);
        data.limit(data.position());
        data.rewind();
        SimMessage reply = new SimMessage(varName, data);
        if (!this.outQueue.offer(reply)) {
            LOG.warning("Output queue is full.");
        }
    }

    private void interpretMessage(MsgToPLC eventMsg) {
        if (eventMsg instanceof OpenShutter) {
            ShutterSide side = this.leastExtended().opposite();
            this.simulateMotion(side, this.sdinfo.get((Object)side).homePos);
            this.closingSide = side.opposite();
        } else if (eventMsg instanceof CloseShutter) {
            ShutterSide side = this.closingSide;
            this.simulateMotion(side, this.sdinfo.get((Object)side).deployedPos);
            this.closingSide = null;
        } else if (eventMsg instanceof TakeExposure) {
            ShutterSide side = this.leastExtended().opposite();
            this.simulateMotion(side, this.sdinfo.get((Object)side).homePos);
            this.simulateMotion(side.opposite(), this.sdinfo.get((Object)side.opposite()).deployedPos);
        } else if (eventMsg instanceof MoveAxisAbsolutePLC) {
            MoveAxisAbsolute abs = ((MoveAxisAbsolutePLC)eventMsg).getStatusBusMessage();
            ShutterSide side = ShutterSide.fromAxis((Axis)Axis.fromName((String)abs.getAxisName()));
            this.simulateMotion(side, abs.getPosition());
            this.closingSide = null;
        } else if (eventMsg instanceof GoToProd) {
            this.setInitialPositions();
            this.sendStatus();
        } else if (eventMsg instanceof ChangeBrakeState) {
            this.simulateChangeBrakeState((ChangeBrakeState)eventMsg);
        }
    }

    private void simulateChangeBrakeState(ChangeBrakeState msg) {
        boolean brakeEngaged;
        ShutterSide side = msg.getAxis().isPlusXSide() ? ShutterSide.PLUSX : ShutterSide.MINUSX;
        this.sdinfo.get((Object)side).brakeEngaged = brakeEngaged = msg.getState() == ChangeBrakeState.State.ENGAGED;
        this.sendStatus();
    }

    private void setInitialPositions() {
        this.sdinfo.put(ShutterSide.PLUSX, new SideInfo(750.0, false, 0.0, 750.0));
        this.sdinfo.put(ShutterSide.MINUSX, new SideInfo(750.0, false, 750.0, 0.0));
        this.closingSide = null;
    }

    private ShutterSide leastExtended() {
        if (this.sdinfo.get(ShutterSide.PLUSX).extent() < this.sdinfo.get(ShutterSide.MINUSX).extent()) {
            return ShutterSide.PLUSX;
        }
        return ShutterSide.MINUSX;
    }

    private void simulateMotion(ShutterSide side, double targetPos) {
        double startPos = this.sdinfo.get((Object)side).position;
        Duration dur = Duration.ofSeconds(1L);
        MotionDone motion = new MotionDone.Builder().side(side).startPosition(startPos).targetPosition(targetPos).startTime(CCSTimeStamp.currentTime()).endPosition(targetPos).targetDuration(dur).actualDuration(dur).addEncoderSample(new EncoderSample(CCSTimeStamp.currentTime(), 12345.0)).addHallTransition(new HallTransition(CCSTimeStamp.currentTime(), 321, 3.14159, true)).build();
        this.sdinfo.get((Object)side).position = targetPos;
        MotionDonePLC plcMotion = new MotionDonePLC(0, motion);
        PLCVariableDictionary.OutVariable var = this.dictionary.getOutVariable(plcMotion.getClass());
        if (var == null) {
            LOG.warning(String.format("Outgoing message %s not in dictionary.", plcMotion.getClass().getName()));
        } else {
            this.sendMessage(var.varName, plcMotion);
        }
        this.sendStatus();
    }

    private void sendStatus() {
        EnumMap<ShutterSide, ShutterStatus.AxisStatus> axes = new EnumMap<ShutterSide, ShutterStatus.AxisStatus>(ShutterSide.class);
        for (ShutterSide side : ShutterSide.values()) {
            ShutterStatus.AxisStatus axstat = new ShutterStatus.AxisStatus(this.sdinfo.get((Object)side).position, 0.0, 0.0, true, this.sdinfo.get((Object)side).brakeEngaged, false, false, true, 0, 30.0);
            axes.put(side, axstat);
        }
        ShutterStatus status = new ShutterStatus(0, true, 0, axes);
        ShutterStatusPLC plcStatus = new ShutterStatusPLC(0, status);
        PLCVariableDictionary.OutVariable var = this.dictionary.getOutVariable(plcStatus.getClass());
        if (var == null) {
            LOG.warning(String.format("Outgoing message %s not in dictionary.", plcStatus.getClass().getName()));
        } else {
            this.sendMessage(var.varName, plcStatus);
        }
    }

    private static final class SideInfo {
        double position;
        boolean brakeEngaged;
        final double homePos;
        final double deployedPos;
        final double fullStroke;
        final double direction;

        SideInfo(double position, boolean brakeEngaged, double homePos, double deployedPos) {
            this.position = position;
            this.brakeEngaged = brakeEngaged;
            this.homePos = homePos;
            this.deployedPos = deployedPos;
            double s = deployedPos - homePos;
            this.direction = Math.signum(s);
            this.fullStroke = Math.abs(s);
        }

        boolean isExtended() {
            return this.extent() > 0.99;
        }

        boolean isRetracted() {
            return this.extent() < 0.01;
        }

        double extent() {
            return this.direction * (this.position - this.homePos) / this.fullStroke;
        }
    }
}

