/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ads.ADSDriver;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.shutter.PLCVariableDictionary;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.SimMessage;
import org.lsst.ccs.subsystem.shutter.SimulatedShutter;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.BladeSetPosition;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.Disable;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Enable;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.GoToProd;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.PLCMsg;
import org.lsst.ccs.subsystem.shutter.plc.Reset;
import org.lsst.ccs.subsystem.shutter.plc.ShutterStatusPLC;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.plc.Timer;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public class Controller {
    @ConfigurationParameter(isFinal=true, description="IP address of the shutter controller.")
    private volatile String plcIPaddr = "0.0.0.0";
    @ConfigurationParameter(isFinal=true, description="AMS address of the shutter controller.")
    private volatile String plcAMSaddr = "0.0.0.0.1.1";
    @ConfigurationParameter(isFinal=true, description="Local AMS address used by the subsystem.")
    private volatile String localAMSaddr = "0.0.0.1.1.1";
    @ConfigurationParameter(isFinal=true, description="Startup delay for the notification reader.")
    private volatile Duration noticeReaderStartupDelay = Duration.ofSeconds(2L);
    @ConfigurationParameter(isFinal=true, description="Restart delay for the notification reader.")
    private volatile Duration noticeReaderRestartDelay = Duration.ofMillis(10L);
    @ConfigurationParameter(isFinal=true, description="Ack timeout for commands sent to the shutter controller.")
    private volatile Duration plcAckTimeout = Duration.ofSeconds(30L);
    @ConfigurationParameter(isFinal=true, description="The minimum exposure time.")
    private volatile Duration minExposureTime = Duration.ofMillis(100L);
    @ConfigurationParameter(isFinal=true, description="Reference positions for the -X blade set.")
    private volatile Map<String, Double> referenceMinusXpositions = new HashMap<String, Double>();
    @ConfigurationParameter(isFinal=true, description="Reference positions for the +X blade set.")
    private volatile Map<String, Double> referencePlusXpositions = new HashMap<String, Double>();
    @ConfigurationParameter(isFinal=true, description="Move blade sets at this speed (mm/sec) when centering. mm/sec.")
    private volatile double centeringSpeed = 20.0;
    @ConfigurationParameter(isFinal=true, description="Max speed (mm/sec) to attain during a stroke.")
    private volatile double maxStrokeSpeed = 1667.0;
    private static final Logger LOG = Logger.getLogger((String)Controller.class.getName());
    private ADSDriver driver;
    private PeriodicTask plcReceptionTask;
    private Map<Class<? extends MsgToPLC>, VariableHandle> writableVarHandles;
    private CountDownLatch plcReceptionStopLatch;
    private List<Axis> centeringOrder;
    private SimulatedShutter simShutter;
    private final PLCVariableDictionary plcVarDict;
    private final AtomicReference<MessageWithState> pendingMessage;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Publisher publish;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile StateMachine machine;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    private static final int PLC_DISABLED_STATE = 10000;
    private static final int PLC_STILL_STATE = 21010;
    private BlockingQueue<SimMessage> simulationQueue;

    public Controller() {
        this.referencePlusXpositions.put(BladeSetPosition.HOME.getKey(), 0.0);
        this.referencePlusXpositions.put(BladeSetPosition.RETRACTED.getKey(), 1.0);
        this.referencePlusXpositions.put(BladeSetPosition.CENTERED.getKey(), 374.5);
        this.referencePlusXpositions.put(BladeSetPosition.EXTENDED.getKey(), 749.0);
        this.referenceMinusXpositions.put(BladeSetPosition.HOME.getKey(), 750.0);
        this.referenceMinusXpositions.put(BladeSetPosition.RETRACTED.getKey(), 749.0);
        this.referenceMinusXpositions.put(BladeSetPosition.CENTERED.getKey(), 375.5);
        this.referenceMinusXpositions.put(BladeSetPosition.EXTENDED.getKey(), 1.0);
        PLCVariableDictionary dict = new PLCVariableDictionary();
        dict.addMsgToPLC(Calibrate.class, Calibrate::new);
        dict.addMsgToPLC(ChangeAxisEnablePLC.class, ChangeAxisEnablePLC::new);
        dict.addMsgToPLC(ChangeBrakeState.class, ChangeBrakeState::new);
        dict.addMsgToPLC(ClearAllFaultsPLC.class, ClearAllFaultsPLC::new);
        dict.addMsgToPLC(ClearAxisFaultsPLC.class, ClearAxisFaultsPLC::new);
        dict.addMsgToPLC(CloseShutter.class, CloseShutter::new);
        dict.addMsgToPLC(DisableAllAxesPLC.class, DisableAllAxesPLC::new);
        dict.addMsgToPLC(EnableAllAxesPLC.class, EnableAllAxesPLC::new);
        dict.addMsgToPLC(GoToProd.class, GoToProd::new);
        dict.addMsgToPLC(MoveAxisAbsolutePLC.class, MoveAxisAbsolutePLC::new);
        dict.addMsgToPLC(MoveAxisRelativePLC.class, MoveAxisRelativePLC::new);
        dict.addMsgToPLC(OpenShutter.class, OpenShutter::new);
        dict.addMsgToPLC(Reset.class, Reset::new);
        dict.addMsgToPLC(TakeExposure.class, TakeExposure::new);
        dict.addMsgToCCS(CalibDone.class, CalibDone::new, msg -> this.machine.calibDone((CalibDone)msg));
        dict.addMsgToCCS(Disable.class, Disable::new, msg -> this.machine.disable());
        dict.addMsgToCCS(Enable.class, Enable::new, msg -> this.machine.enable());
        dict.addMsgToCCS(Error.class, Error::new, msg -> this.machine.error());
        dict.addMsgToCCS(Ignored.class, Ignored::new, msg -> this.machine.ignored(((Ignored)msg).getReason()));
        dict.addMsgToCCS(MotionDonePLC.class, MotionDonePLC::new, msg -> this.machine.motionDone((MotionDonePLC)msg));
        dict.addMsgToCCS(ShutterStatusPLC.class, ShutterStatusPLC::new, msg -> EventReply.accepted());
        dict.addMsgToCCS(Timer.class, Timer::new, msg -> this.machine.timer());
        this.plcVarDict = dict;
        this.pendingMessage = new AtomicReference();
    }

    boolean isBadExposureTime(Duration exposureTime) {
        return exposureTime.compareTo(this.minExposureTime) < 0;
    }

    synchronized void terminateContact() {
        if (this.plcReceptionTask != null) {
            this.plcReceptionTask.cancel(true);
        }
        if (this.driver != null) {
            this.driver.close();
        }
    }

    synchronized boolean makePartialContact() {
        try {
            if (this.plcReceptionTask != null) {
                this.plcReceptionTask.cancel(true);
            }
            if (this.driver == null) {
                this.driver = new ADSDriver(this.localAMSaddr);
            } else {
                this.driver.close();
            }
            if (this.writableVarHandles != null) {
                this.writableVarHandles.clear();
            } else {
                this.writableVarHandles = new HashMap<Class<? extends MsgToPLC>, VariableHandle>();
            }
            this.driver.open(this.plcAMSaddr, this.plcIPaddr);
            PLCVariableDictionary.InVariable vreset = this.plcVarDict.getInVariable(Reset.class);
            this.writableVarHandles.put(vreset.klass, this.driver.getVariableHandle(vreset.varName));
            this.driver.requestNotifications(this.driver.getVariableHandle(vreset.ackName), Duration.ZERO, Duration.ZERO, true);
            this.driver.requestNotifications(this.driver.getVariableHandle(this.plcVarDict.getOutVariable(ShutterStatusPLC.class).varName), Duration.ZERO, Duration.ZERO, true);
            this.subsys.getScheduler().setLogger(LOG);
            this.startPLCReceptionTask();
            return true;
        }
        catch (Exception exc) {
            LOG.severe((Object)"Could not contact the shutter controller.", (Throwable)exc);
            this.machine.contactLost();
            return false;
        }
    }

    synchronized boolean makeFullContact() {
        try {
            this.plcReceptionTask.cancel(true);
            this.plcReceptionStopLatch.await();
            List<PLCVariableDictionary.InVariable> inVars = this.plcVarDict.getAllInVariables();
            for (PLCVariableDictionary.InVariable var : inVars) {
                this.writableVarHandles.put(var.klass, this.driver.getVariableHandle(var.varName));
            }
            for (PLCVariableDictionary.InVariable var : inVars) {
                this.driver.requestNotifications(this.driver.getVariableHandle(var.ackName), Duration.ZERO, Duration.ZERO, true);
            }
            List<PLCVariableDictionary.OutVariable> outVars = this.plcVarDict.getAllOutVariables();
            for (PLCVariableDictionary.OutVariable var : outVars) {
                this.driver.requestNotifications(this.driver.getVariableHandle(var.varName), Duration.ZERO, Duration.ZERO, true);
            }
            this.startPLCReceptionTask();
            return true;
        }
        catch (Exception exc) {
            LOG.severe((Object)"Lost contact with the shutter controller.", (Throwable)exc);
            this.machine.contactLost();
            return false;
        }
    }

    synchronized boolean shutterIsReady() {
        ShutterStatus status = this.publish.getShutterStatus();
        if (status == null) {
            LOG.warning((Object)"No shutter status has yet been received.");
            return false;
        }
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        return info.shutterIsReady();
    }

    synchronized boolean readyForCalibration() {
        ShutterStatus status = this.publish.getShutterStatus();
        if (status == null) {
            LOG.warning((Object)"No shutter status has yet been received.");
            return false;
        }
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        return info.readyForCalibration();
    }

    synchronized void startFirstCentering() {
        ShutterStatus status = this.publish.getShutterStatus();
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        assert (status != null) : "Null shutter status";
        assert (this.centeringOrder == null) : "A centering order should not exist yet.";
        this.centeringOrder = info.getCenteringOrder();
        this.machine.getActions().relay(new MoveAxisAbsolutePLC(new MoveAxisAbsolute(this.centeringOrder.get(0).getName(), info.getCentered(this.centeringOrder.get(0)), this.centeringSpeed)));
    }

    synchronized void startSecondCentering() {
        assert (this.centeringOrder != null) : "A centering order wasn't chosen.";
        ShutterStatus status = this.publish.getShutterStatus();
        ShutterInfo info = new ShutterInfo(status, this.referenceMinusXpositions, this.referencePlusXpositions);
        this.machine.getActions().relay(new MoveAxisAbsolutePLC(new MoveAxisAbsolute(this.centeringOrder.get(1).getName(), info.getCentered(this.centeringOrder.get(1)), this.centeringSpeed)));
        this.centeringOrder = null;
    }

    private void startPLCReceptionTask() throws InterruptedException {
        ADSDriver drv = this.driver;
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(1);
        Runnable reception = () -> Controller.plcReceptionTaskBody(drv, this.plcVarDict, this.pendingMessage, this.publish, this.machine, startLatch, stopLatch);
        this.plcReceptionStopLatch = stopLatch;
        this.plcReceptionTask = this.subsys.getScheduler().scheduleWithFixedDelay(reception, this.noticeReaderStartupDelay.toMillis(), this.noticeReaderRestartDelay.toMillis(), TimeUnit.MILLISECONDS, "Notification reception", Level.SEVERE);
        startLatch.await();
    }

    private static void plcReceptionTaskBody(ADSDriver driver, PLCVariableDictionary plcVarDict, AtomicReference<MessageWithState> pendingMessage, Publisher publish, StateMachine machine, CountDownLatch startLatch, CountDownLatch stopLatch) {
        ArrayList leftovers = new ArrayList();
        driver.drainNotifications(leftovers);
        startLatch.countDown();
        LOG.info((Object)"The notice-reading loop has started.");
        try {
            while (true) {
                Notification notice = driver.takeNotification();
                String varName = notice.getVariableHandle().getName();
                ByteBuffer data = notice.getData();
                Controller.processMessageData(varName, data, plcVarDict, pendingMessage, publish, machine);
            }
        }
        catch (InterruptedException exc) {
            stopLatch.countDown();
            LOG.info((Object)"Normal stop of the notice-reading loop.");
            return;
        }
    }

    private static void simReceptionTaskBody(PLCVariableDictionary plcVarDict, AtomicReference<MessageWithState> pendingMessage, Publisher publish, StateMachine machine, BlockingQueue<SimMessage> simulationQueue) {
        LOG.info((Object)"The simulated notice-reading loop has started.");
        try {
            while (true) {
                SimMessage msg = simulationQueue.take();
                String varName = msg.varName;
                ByteBuffer data = msg.data;
                LOG.info((Object)("Read message with var name " + varName));
                Controller.processMessageData(varName, data, plcVarDict, pendingMessage, publish, machine);
            }
        }
        catch (InterruptedException exc) {
            LOG.info((Object)"Normal stop of the simulated notice-reading loop.");
            return;
        }
    }

    private static void processMessageData(String varName, ByteBuffer data, PLCVariableDictionary plcVarDict, AtomicReference<MessageWithState> pendingMessage, Publisher publish, StateMachine machine) throws InterruptedException {
        if (Controller.checkMessageSetVersion(data, pendingMessage.get(), machine)) {
            return;
        }
        PLCVariableDictionary.InVariable ackVar = plcVarDict.getInVariable(varName);
        PLCVariableDictionary.OutVariable outVar = plcVarDict.getOutVariable(varName);
        assert (ackVar != null || outVar != null) : "Unknown message type received from PLC.";
        assert (ackVar == null || outVar == null) : "Ambiguous message received from PLC.";
        if (ackVar != null) {
            LOG.fine((Object)"Calling handleAckMessage().");
            Controller.handleAckMessage(data, ackVar, pendingMessage.get());
            LOG.fine((Object)"Returned from handleAckMessage()");
        } else if (outVar != null && outVar.klass == ShutterStatusPLC.class) {
            LOG.fine((Object)"Calling handleStatusMessage().");
            Controller.handleStatusMessage(data, outVar, publish, machine);
            LOG.fine((Object)"Returned from handleStatusMessage().");
        } else if (outVar != null) {
            LOG.fine((Object)"Calling handleEventMessage");
            Controller.handleEventMessage(data, outVar);
            LOG.fine((Object)"Returned from handleEventMessage().");
        }
    }

    private static boolean checkMessageSetVersion(ByteBuffer data, MessageWithState pending, StateMachine machine) {
        boolean failure = false;
        if (PLCMsg.messageVersionIsBad(data)) {
            if (pending != null) {
                pending.badAck();
            } else {
                machine.contactLost();
            }
            failure = true;
        }
        return failure;
    }

    private static void handleAckMessage(ByteBuffer data, PLCVariableDictionary.InVariable ackVar, MessageWithState pending) {
        try {
            MsgToPLC msg = ackVar.ackDecoder.apply(data);
            if (pending != null) {
                pending.ack(msg);
            } else {
                LOG.severe((Object)("Unexpected ack received, message class = " + msg.getClass().getSimpleName()));
            }
        }
        catch (Exception exc) {
            LOG.severe((Object)"Error during ack decoding.", (Throwable)exc);
        }
    }

    private static void handleStatusMessage(ByteBuffer data, PLCVariableDictionary.OutVariable outVar, Publisher publish, StateMachine machine) {
        ShutterStatusPLC status;
        try {
            status = (ShutterStatusPLC)outVar.decoder.apply(data);
        }
        catch (Exception exc) {
            LOG.severe((Object)"Error during status message decoding.", (Throwable)exc);
            return;
        }
        LOG.fine((Object)("Received ShutterStatus. " + status.toString()));
        publish.updateShutterStatus(status.getStatusBusMessage());
        if (status.getSmState() == 10000) {
            machine.plcIsDisabled();
        } else if (status.getSmState() == 21010) {
            machine.plcIsEnabled();
        }
    }

    private static void handleEventMessage(ByteBuffer data, PLCVariableDictionary.OutVariable outVar) throws InterruptedException {
        MsgToCCS msg;
        try {
            msg = outVar.decoder.apply(data);
        }
        catch (Exception exc) {
            LOG.severe((Object)"Error during message decoding.", (Throwable)exc);
            return;
        }
        outVar.submitter.apply(msg);
    }

    synchronized void resetPLC() {
        this.relay(new Reset(this.maxStrokeSpeed));
    }

    void simulateResetPLC() {
        this.simulateRelay(new Reset(this.maxStrokeSpeed));
    }

    synchronized void relay(MsgToPLC msg) {
        assert (this.pendingMessage.get() == null) : "relay() entered while still awaiting an ack.";
        try {
            this.pendingMessage.set(new MessageWithState(msg));
            this.sendPendingMessage();
            this.finishPendingMessage();
        }
        finally {
            this.pendingMessage.set(null);
        }
    }

    private void sendPendingMessage() {
        MsgToPLC msg = this.pendingMessage.get().getMessage();
        try {
            PLCVariableDictionary.InVariable inVar = this.plcVarDict.getInVariable(msg.getClass());
            assert (inVar != null) : "Message not recognized by relay().";
            VariableHandle handle = this.writableVarHandles.get(msg.getClass());
            assert (handle != null) : "No handle for writing the PLC message variable.";
            ByteBuffer msgBytes = handle.createBuffer();
            msg.encode(msgBytes);
            this.driver.writeVariable(handle, msgBytes);
            this.pendingMessage.get().sent();
        }
        catch (Exception exc) {
            LOG.severe((Object)"Trouble sending a message to the PLC.", (Throwable)exc);
            this.pendingMessage.get().sendError();
        }
    }

    void simulateRelay(MsgToPLC msg) {
        LOG.info((Object)("Simulating sending of " + msg.getClass().getSimpleName()));
        assert (this.pendingMessage.get() == null) : "simulateRelay() entered while still awaiting an ack.";
        try {
            this.pendingMessage.set(new MessageWithState(msg));
            LOG.info((Object)("Pending message state = " + this.pendingMessage.get().getState().toString()));
            this.pendingMessage.get().sent();
            this.simShutter.accept(msg);
            this.finishPendingMessage();
        }
        finally {
            this.pendingMessage.set(null);
        }
    }

    synchronized void simulateContact() {
        if (this.plcReceptionTask == null) {
            Runnable reception = () -> Controller.simReceptionTaskBody(this.plcVarDict, this.pendingMessage, this.publish, this.machine, this.simulationQueue);
            this.simulationQueue = new ArrayBlockingQueue<SimMessage>(1000);
            this.plcReceptionTask = this.subsys.getScheduler().scheduleWithFixedDelay(reception, this.noticeReaderStartupDelay.toMillis(), this.noticeReaderRestartDelay.toMillis(), TimeUnit.MILLISECONDS, "Simulated notification reception", Level.SEVERE);
            this.simShutter = new SimulatedShutter(this.subsys.getScheduler(), this.simulationQueue, this.plcVarDict);
            this.simShutter.start();
        }
    }

    private void finishPendingMessage() {
        LOG.fine((Object)String.format("Waiting %s for ack.", this.plcAckTimeout));
        this.pendingMessage.get().waitForFinish(this.plcAckTimeout);
        LOG.fine((Object)"Done waiting.");
        MsgToPLC msg = this.pendingMessage.get().getMessage();
        switch (this.pendingMessage.get().getState()) {
            case SENDING: 
            case AWAITING_ACK: {
                LOG.severe((Object)"Incorrect handling of message sending.");
                break;
            }
            case SEND_ERROR: {
                this.machine.contactLost();
                break;
            }
            case ACK_TIMEOUT: {
                LOG.severe((Object)("Ack timeout when sending " + msg.getClass().getSimpleName()));
                this.machine.contactLost();
                break;
            }
            case BAD_ACK: {
                LOG.severe((Object)("Mis-matched ack of " + msg.getClass().getSimpleName()));
                this.machine.contactLost();
                break;
            }
            case GOOD_ACK: {
                LOG.fine((Object)"Matching ack received.");
                break;
            }
            case INTERRUPTED: {
                LOG.severe((Object)"Interrupted while waiting for ack. This may cause trouble later.");
            }
        }
    }

    private static class ShutterInfo {
        private final ShutterStatus status;
        private final Map<Axis, Map<BladeSetPosition, Double>> config;

        ShutterInfo(ShutterStatus status, Map<String, Double> minusXConfig, Map<String, Double> plusXConfig) {
            this.status = status;
            this.config = new EnumMap<Axis, Map<BladeSetPosition, Double>>(Axis.class);
            EnumMap<Axis, Map<String, Double>> conf = new EnumMap<Axis, Map<String, Double>>(Axis.class);
            conf.put(Axis.getPlusXSide(), plusXConfig);
            conf.put(Axis.getMinusXSide(), minusXConfig);
            for (Axis ax : Axis.values()) {
                EnumMap posmap = new EnumMap(BladeSetPosition.class);
                for (BladeSetPosition pos : BladeSetPosition.values()) {
                    posmap.put(pos, ((Map)conf.get(ax)).get(pos.getKey()));
                }
                this.config.put(ax, posmap);
            }
        }

        private double getParam(Axis axis, BladeSetPosition pos) {
            return this.config.get(axis).get((Object)pos);
        }

        public double getHome(Axis axis) {
            return this.getParam(axis, BladeSetPosition.HOME);
        }

        public double getRetracted(Axis axis) {
            return this.getParam(axis, BladeSetPosition.RETRACTED);
        }

        public double getCentered(Axis axis) {
            return this.getParam(axis, BladeSetPosition.CENTERED);
        }

        public double getExtended(Axis axis) {
            return this.getParam(axis, BladeSetPosition.EXTENDED);
        }

        public boolean isRetracted(Axis axis) {
            double pos = this.status.getAxisStatus(ShutterSide.fromAxis((Axis)axis)).getActPos();
            return Math.abs(pos - this.getHome(axis)) <= Math.abs(this.getRetracted(axis) - this.getHome(axis));
        }

        public boolean isExtended(Axis axis) {
            double pos = this.status.getAxisStatus(ShutterSide.fromAxis((Axis)axis)).getActPos();
            return Math.abs(pos - this.getHome(axis)) >= Math.abs(this.getExtended(axis) - this.getHome(axis));
        }

        public boolean shutterIsClosed() {
            return this.isRetracted(Axis.AXIS0) && this.isExtended(Axis.AXIS1) || this.isExtended(Axis.AXIS0) && this.isRetracted(Axis.AXIS1);
        }

        public boolean axesAreEnabled() {
            return this.status.getAxisStatus(ShutterSide.PLUSX).isEnabled() && this.status.getAxisStatus(ShutterSide.MINUSX).isEnabled();
        }

        public boolean brakesAreReleased() {
            return !this.status.getAxisStatus(ShutterSide.PLUSX).isBrakeEngaged() && !this.status.getAxisStatus(ShutterSide.MINUSX).isBrakeEngaged();
        }

        public boolean axesAreHomed() {
            return this.status.getAxisStatus(ShutterSide.PLUSX).isHomed() && this.status.getAxisStatus(ShutterSide.MINUSX).isHomed();
        }

        public boolean shutterIsReady() {
            boolean ready = true;
            if (!this.shutterIsClosed()) {
                LOG.warning((Object)"Shutter not ready - not closed.");
                ready = false;
            }
            if (!this.axesAreEnabled()) {
                LOG.warning((Object)"Shutter not ready - axes not enabled.");
                ready = false;
            }
            if (!this.brakesAreReleased()) {
                LOG.warning((Object)"Shutter not ready - brakes not released.");
                ready = false;
            }
            if (!this.axesAreHomed()) {
                LOG.warning((Object)"Shutter not ready - axes not homed.");
                ready = false;
            }
            return ready;
        }

        public boolean readyForCalibration() {
            boolean ready = true;
            if (!this.axesAreEnabled()) {
                LOG.warning((Object)"Shutter not ready - axes not enabled.");
                ready = false;
            }
            if (!this.brakesAreReleased()) {
                LOG.warning((Object)"Shutter not ready - brakes not released.");
                ready = false;
            }
            if (!this.axesAreHomed()) {
                LOG.warning((Object)"Shutter not ready - axes not homed.");
                ready = false;
            }
            return ready;
        }

        public List<Axis> getCenteringOrder() {
            double extent2;
            double extent1 = Math.abs(this.status.getAxisStatus(ShutterSide.fromAxis((Axis)Axis.AXIS0)).getActPos() - this.getHome(Axis.AXIS0));
            if (extent1 >= (extent2 = Math.abs(this.status.getAxisStatus(ShutterSide.fromAxis((Axis)Axis.AXIS1)).getActPos() - this.getHome(Axis.AXIS1)))) {
                return Arrays.asList(Axis.AXIS0, Axis.AXIS1);
            }
            return Arrays.asList(Axis.AXIS1, Axis.AXIS0);
        }
    }

    private static class MessageWithState {
        private final MsgToPLC msg;
        private State state;
        private MsgToPLC ackMsg;
        private final CountDownLatch latch;

        MessageWithState(MsgToPLC msg) {
            this.msg = msg;
            this.ackMsg = null;
            this.latch = new CountDownLatch(1);
            this.state = State.SENDING;
        }

        synchronized void sent() {
            if (this.state == State.SENDING) {
                this.setState(State.AWAITING_ACK);
            }
        }

        synchronized void sendError() {
            if (this.state == State.SENDING) {
                this.setState(State.SEND_ERROR);
            }
        }

        synchronized void ack(MsgToPLC ackMsg) {
            if (this.state == State.AWAITING_ACK) {
                this.ackMsg = ackMsg;
                if (ackMsg.hasSameIdent(this.msg)) {
                    this.setState(State.GOOD_ACK);
                } else {
                    this.setState(State.BAD_ACK);
                }
            }
        }

        synchronized void badAck() {
            if (this.state == State.AWAITING_ACK) {
                this.setState(State.BAD_ACK);
            }
        }

        private synchronized void setState(State newState) {
            this.state = newState;
            if (this.state.compareTo(State.AWAITING_ACK) > 0) {
                this.latch.countDown();
            }
        }

        void waitForFinish(Duration timeout) {
            try {
                boolean timedOut;
                boolean bl = timedOut = !this.latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
                if (timedOut) {
                    this.setState(State.ACK_TIMEOUT);
                }
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
                this.setState(State.INTERRUPTED);
            }
        }

        MsgToPLC getMessage() {
            return this.msg;
        }

        synchronized MsgToPLC getAck() {
            return this.ackMsg;
        }

        synchronized State getState() {
            return this.state;
        }

        static enum State {
            SENDING,
            AWAITING_ACK,
            SEND_ERROR,
            GOOD_ACK,
            BAD_ACK,
            ACK_TIMEOUT,
            INTERRUPTED;

        }
    }
}

