/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Context;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleContext;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;
import org.mockito.Mockito;

public class SimpleStateTest {
    private static final SimpleContext DUMMY_CONTEXT = (SimpleContext)Mockito.mock(SimpleContext.class);
    private final TestState stateObj = new TestState();

    @Test
    public void testGetContext() {
        Assertions.assertEquals((Object)DUMMY_CONTEXT, (Object)this.stateObj.getContext(), (String)"Wrong context retrieved.");
    }

    @Test
    public void testRejection() throws InterruptedException {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            EventReply reply = this.stateObj.contactLost();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event contactLost() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.plcIsEnabled();
            Assertions.assertTrue((boolean)reply.wasAccepted(), (String)"plcIsEnabled() should have been accepted.");
        }, () -> {
            EventReply reply = this.stateObj.plcIsDisabled();
            Assertions.assertTrue((boolean)reply.wasAccepted(), (String)"plcIsDisabled() should have been accepted.");
        }, () -> {
            EventReply reply = this.stateObj.resync();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event resync() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.syncTimeout();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event syncTimeout() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.enable();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event enable() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.disable();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event disable() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.motionDone(new MotionDonePLC(1, null));
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event motionDone() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.calibrate(new Calibrate());
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event calibrate() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.calibDone(new CalibDone(1, new double[]{0.0, 0.0}, new double[]{0.0, 0.0}, () -> 0.0));
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event calibDone() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.error();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event error() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.reset();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event reset() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.takeExposure(Duration.ZERO);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event takeExposure() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.openShutter();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event openShutter() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.timer();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event timer() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.closeShutter();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event closeShutter() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.ignored(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event ignored() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.gotoProd();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event gotoProd() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.gotoCenter();
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event gotoCenter() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.moveAxisAbsolute(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event moveAxisAbsolute() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.moveAxisRelative(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event moveAxisRelative() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.clearAllFaults(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event clearAllFaults() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.changeAxisEnable(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event changeAxisEnable() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.clearAxisFaults(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event clearAxisFaults() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.enableAllAxes(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event enableAllAxes() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            EventReply reply = this.stateObj.disableAllAxes(null);
            reply.wasAccepted();
            Assertions.assertEquals((Object)"Event disableAllAxes() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }});
    }

    private static class TestState
    extends SimpleState<SimpleContext<?>> {
        public TestState() {
            super((Context)DUMMY_CONTEXT);
        }

        public Logger getLogger() {
            return null;
        }
    }
}

