/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.plc.GoToProd;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.InSync;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EnabledTest {
    @Test
    public void testTransitions() {
        InSync dummyContext = (InSync)Mockito.mock(InSync.class);
        Actions mockActions = (Actions)Mockito.mock(Actions.class);
        Mockito.when((Object)mockActions.shutterIsReady()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Enabled sm = new Enabled(mockActions, dummyContext);
        sm.init();
        sm.reset();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).resetPLC();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OTHER);
        sm.error();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OTHER);
        sm.gotoProd();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).shutterIsReady();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).relay((MsgToPLC)ArgumentMatchers.any(GoToProd.class));
        sm.error();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.OTHER);
        sm.gotoProd();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).shutterIsReady();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).relay((MsgToPLC)ArgumentMatchers.any(GoToProd.class));
        sm.reset();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).resetPLC();
        sm.gotoProd();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).shutterIsReady();
        Mockito.reset((Object[])new Actions[]{mockActions});
        sm.openShutter();
        Mockito.verifyZeroInteractions((Object[])new Object[]{mockActions});
        Mockito.verifyZeroInteractions((Object[])new Object[]{dummyContext});
    }
}

