package org.lsst.ccs.subsystem.shutter.statemachine;

/**
 * Response to an event, returned by event methods in states and contexts. 
 * @author tether
 */
public interface EventReply {

    /**
     * Returns an event reply for which {@code wasAccepted()} returns {@code true} and does not block.
     * @return The reply instance.
     */
    static EventReply accepted() {return PromptReply.ACCEPTED;}

    /**
     * Gets a boolean flag, blocking if need be, which tells whether an event was accepted.
     * @return true if the event was accepted, else false.
     * @see #getMessage()
     * @throws InterruptedException
     */
    boolean wasAccepted() throws InterruptedException;

    /** Gets a short string describing the acceptance or rejection.
     * @return The string.
     * @throws InterruptedException
     * @throws IllegalStateException if {@code wasAccepted()} wasn't called or threw an exception.
     * @see #wasAccepted() 
     */
    String getMessage() throws InterruptedException;
}
