/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.status;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;

public final class ShutterStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int motionProfile;
    private final boolean isCalibrated;
    private final int smState;
    private final Map<ShutterSide, AxisStatus> axstatus;

    public ShutterStatus(int motionProfile, boolean isCalibrated, int smState, Map<ShutterSide, AxisStatus> axes) {
        this.motionProfile = motionProfile;
        this.isCalibrated = isCalibrated;
        this.smState = smState;
        this.axstatus = new EnumMap<ShutterSide, AxisStatus>(axes);
    }

    public int getMotionProfile() {
        return this.motionProfile;
    }

    public boolean isCalibrated() {
        return this.isCalibrated;
    }

    public int getSmState() {
        return this.smState;
    }

    public AxisStatus getAxisStatus(ShutterSide side) {
        return this.axstatus.get((Object)side);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("ShutterStatus{motionProfile=" + this.motionProfile + ", isCalibrated=" + this.isCalibrated + ", smState=" + this.smState);
        for (ShutterSide side : ShutterSide.values()) {
            buff.append(", axstatus[");
            buff.append((Object)side);
            buff.append("]=");
            buff.append(this.getAxisStatus(side));
        }
        buff.append("}");
        return buff.toString();
    }

    public static final class AxisStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final double actPos;
        private final double actVel;
        private final double setAcc;
        private final boolean enabled;
        private final boolean brakeEngaged;
        private final boolean lowLimit;
        private final boolean highLimit;
        private final boolean isHomed;
        private final int errorID;
        private final double motorTemp;

        public AxisStatus(double actPos, double actVel, double setAcc, boolean enabled, boolean brakeEngaged, boolean lowLimit, boolean highLimit, boolean isHomed, int errorID, double motorTemp) {
            this.actPos = actPos;
            this.actVel = actVel;
            this.setAcc = setAcc;
            this.enabled = enabled;
            this.brakeEngaged = brakeEngaged;
            this.lowLimit = lowLimit;
            this.highLimit = highLimit;
            this.isHomed = isHomed;
            this.errorID = errorID;
            this.motorTemp = motorTemp;
        }

        public String toString() {
            return "AxisStatus{actPos=" + this.actPos + ", actVel=" + this.actVel + ", setAcc=" + this.setAcc + ", enabled=" + this.enabled + ", brakeEngaged=" + this.brakeEngaged + ", lowLimit=" + this.lowLimit + ", highLimit=" + this.highLimit + ", isHomed=" + this.isHomed + ", errorID=" + this.errorID + ", motorTemp=" + this.motorTemp + '}';
        }

        public double getActPos() {
            return this.actPos;
        }

        public double getActVel() {
            return this.actVel;
        }

        public double getSetAcc() {
            return this.setAcc;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isBrakeEngaged() {
            return this.brakeEngaged;
        }

        public boolean atLowLimit() {
            return this.lowLimit;
        }

        public boolean atHighLimit() {
            return this.highLimit;
        }

        public boolean isHomed() {
            return this.isHomed;
        }

        public int getErrorID() {
            return this.errorID;
        }

        public double getMotorTemp() {
            return this.motorTemp;
        }
    }
}

