/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.EnumSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PLCError;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.GoToProd;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.InSync;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EnabledTest {
    @Test
    public void testTransitions() throws InterruptedException {
        InSync dummyContext = (InSync)Mockito.mock(InSync.class);
        Actions mockActions = (Actions)Mockito.mock(Actions.class);
        Mockito.when((Object)mockActions.shutterIsReady()).thenReturn(null, (Object[])new String[]{null, "Not ready."});
        Enabled sm = new Enabled(mockActions, dummyContext);
        DummyChannel chan = new DummyChannel();
        sm.init();
        sm.reset(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).resetPLC();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OTHER);
        sm.error(chan, new Error(0, EnumSet.noneOf(PLCError.class)));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OTHER);
        sm.gotoProd(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).shutterIsReady();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).relay((MsgToPLC)ArgumentMatchers.any(GoToProd.class));
        Assertions.assertNull((Object)sm.getMaintState().getState(), (String)"Maint didn't forget its current state when exited.");
        sm.error(chan, new Error(0, EnumSet.noneOf(PLCError.class)));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.OTHER);
        Assertions.assertNull((Object)sm.getProdState().getState(), (String)"Prod didn't forget its current state when exited.");
        sm.gotoProd(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).shutterIsReady();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).relay((MsgToPLC)ArgumentMatchers.any(GoToProd.class));
        Assertions.assertNull((Object)sm.getMaintState().getState(), (String)"Maint didn't forget its current state when exited.");
        sm.reset(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).resetPLC();
        Assertions.assertNull((Object)sm.getProdState().getState(), (String)"Prod didn't forget its current state when exited.");
        sm.gotoProd(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).shutterIsReady();
        Mockito.reset((Object[])new Actions[]{mockActions});
        sm.openShutter(chan);
        Mockito.verifyZeroInteractions((Object[])new Object[]{mockActions});
        Mockito.verifyZeroInteractions((Object[])new Object[]{dummyContext});
    }
}

