package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.util.logging.Logger;

/**
 * Holds a Disable message sent from the PLC.
 * @author tether
 */
public class Disable extends MsgToCCS {

    /**
     * Constructs from scratch.
     * @param sequence A message sequence number.
     */
    public Disable(final int sequence) {super(sequence);}

    /**
     * Reads and converts the PLC form of the message.
     * @param data The PLC message data buffer.
     */
    public Disable(final ByteBuffer data) {
        super(data);
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
    }

    @Override
    public String toString() {
        return "Disable{" + super.toString() + '}';
    }


}
