/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Events;
import org.lsst.ccs.subsystem.shutter.statemachine.State;

interface Context<C extends Context<?>>
extends Events {
    public String getName();

    public State<C> getState();

    public void init();

    public Actions getActions();

    public void makeTransition(State<C> var1, Runnable var2);

    @Override
    default public EventReply contactLost() {
        return this.getState().contactLost();
    }

    @Override
    default public EventReply ignored(Ignored.Reason reason) {
        return this.getState().ignored(reason);
    }

    @Override
    default public EventReply plcIsEnabled() {
        return this.getState().plcIsEnabled();
    }

    @Override
    default public EventReply plcIsDisabled() {
        return this.getState().plcIsDisabled();
    }

    @Override
    default public EventReply resync() {
        return this.getState().resync();
    }

    @Override
    default public EventReply syncTimeout() {
        return this.getState().syncTimeout();
    }

    @Override
    default public EventReply enable() {
        return this.getState().enable();
    }

    @Override
    default public EventReply disable() {
        return this.getState().disable();
    }

    @Override
    default public EventReply motionDone(MotionDonePLC mot) {
        return this.getState().motionDone(mot);
    }

    @Override
    default public EventReply calibrate(Calibrate cal) {
        return this.getState().calibrate(cal);
    }

    @Override
    default public EventReply calibDone(CalibDone cal) {
        return this.getState().calibDone(cal);
    }

    @Override
    default public EventReply error() {
        return this.getState().error();
    }

    @Override
    default public EventReply reset() {
        return this.getState().reset();
    }

    @Override
    default public EventReply takeExposure(Duration exposureTime) {
        return this.getState().takeExposure(exposureTime);
    }

    @Override
    default public EventReply openShutter() {
        return this.getState().openShutter();
    }

    @Override
    default public EventReply timer() {
        return this.getState().timer();
    }

    @Override
    default public EventReply closeShutter() {
        return this.getState().closeShutter();
    }

    @Override
    default public EventReply gotoProd() {
        return this.getState().gotoProd();
    }

    @Override
    default public EventReply gotoCenter() {
        return this.getState().gotoCenter();
    }

    @Override
    default public EventReply homeAxis(HomeAxis req) {
        return this.getState().homeAxis(req);
    }

    @Override
    default public EventReply moveAxisAbsolute(MoveAxisAbsolute req) {
        return this.getState().moveAxisAbsolute(req);
    }

    @Override
    default public EventReply moveAxisRelative(MoveAxisRelative req) {
        return this.getState().moveAxisRelative(req);
    }

    @Override
    default public EventReply clearAllFaults(ClearAllFaults req) {
        return this.getState().clearAllFaults(req);
    }

    @Override
    default public EventReply changeAxisEnable(ChangeAxisEnable req) {
        return this.getState().changeAxisEnable(req);
    }

    @Override
    default public EventReply changeBrakeState(Axis ax, ChangeBrakeState.State newState) {
        return this.getState().changeBrakeState(ax, newState);
    }

    @Override
    default public EventReply clearAxisFaults(ClearAxisFaults req) {
        return this.getState().clearAxisFaults(req);
    }

    @Override
    default public EventReply enableAllAxes(EnableAllAxes req) {
        return this.getState().enableAllAxes(req);
    }

    @Override
    default public EventReply disableAllAxes(DisableAllAxes req) {
        return this.getState().disableAllAxes(req);
    }
}

