/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.plc.Tools;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MotionDonePLC
extends MsgToCCS {
    final MotionDone motion;
    private static final int HALL_TRANSITION_SIZE;
    private static final int ENCODER_SAMPLE_SIZE;

    public MotionDonePLC(int sequence, MotionDone motion) {
        super(sequence);
        this.motion = motion;
    }

    public MotionDonePLC(ByteBuffer data) {
        super(data);
        int i;
        MotionDone.Builder builder = new MotionDone.Builder().side(ShutterSide.fromAxis((Axis)Axis.fromAxisNum((int)data.getInt()))).startTime(Tools.fromDcInstant(data.getLong())).startPosition(data.getDouble()).targetDuration(Tools.fromDcDuration(data.getLong())).targetPosition(data.getDouble()).endPosition(data.getDouble()).actualDuration(Tools.fromDcDuration(data.getLong()));
        int ntrans = data.getInt();
        int maxtrans = data.getInt();
        int nsamples = data.getInt();
        int maxsamples = data.getInt();
        int tranStart = data.position();
        for (i = 0; i < ntrans; ++i) {
            builder.addHallTransition(MotionDonePLC.decodeHallTransition(data));
        }
        data.position(tranStart + maxtrans * HALL_TRANSITION_SIZE);
        for (i = 0; i < nsamples; ++i) {
            builder.addEncoderSample(MotionDonePLC.decodeEncoderSample(data));
        }
        data.position(data.position() + (maxsamples - nsamples) * ENCODER_SAMPLE_SIZE);
        this.motion = builder.build();
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        Axis ax = this.motion.side() == ShutterSide.PLUSX ? Axis.getPlusXSide() : Axis.getMinusXSide();
        data.putInt(ax.getPLCAxisNum());
        data.putLong(Tools.toDcInstant(this.motion.startTime()));
        data.putDouble(this.motion.startPosition());
        data.putLong(Tools.toDcDuration(this.motion.targetDuration()));
        data.putDouble(this.motion.targetPosition());
        data.putDouble(this.motion.endPosition());
        data.putLong(Tools.toDcDuration(this.motion.actualDuration()));
        int ntrans = this.motion.hallTransitions().size();
        int unused = 5;
        data.putInt(ntrans);
        data.putInt(ntrans + 5);
        int nsamples = this.motion.encoderSamples().size();
        data.putInt(nsamples);
        data.putInt(nsamples + 5);
        for (HallTransition trans : this.motion.hallTransitions()) {
            MotionDonePLC.encodeHallTransition(data, trans);
        }
        data.position(data.position() + 5 * HALL_TRANSITION_SIZE);
        for (EncoderSample sample : this.motion.encoderSamples()) {
            MotionDonePLC.encodeEncoderSample(data, sample);
        }
        data.position(data.position() + 5 * ENCODER_SAMPLE_SIZE);
    }

    private static HallTransition decodeHallTransition(ByteBuffer data) {
        int id = data.getInt();
        CCSTimeStamp time = Tools.fromDcInstant(data.getLong());
        double pos = data.getDouble();
        boolean on = Tools.getBoolean(data);
        return new HallTransition(time, id, pos, on);
    }

    private static int encodeHallTransition(ByteBuffer data, HallTransition hall) {
        int start = data.position();
        data.putInt(hall.getSensorId());
        data.putLong(Tools.toDcInstant(hall.getTime()));
        data.putDouble(hall.getPosition());
        Tools.putBoolean(data, hall.isOn());
        return data.position() - start;
    }

    private static EncoderSample decodeEncoderSample(ByteBuffer data) {
        CCSTimeStamp time = Tools.fromDcInstant(data.getLong());
        double pos = data.getDouble();
        return new EncoderSample(time, pos);
    }

    private static int encodeEncoderSample(ByteBuffer data, EncoderSample sample) {
        int start = data.position();
        data.putLong(Tools.toDcInstant(sample.getTime()));
        data.putDouble(sample.getPosition());
        return data.position() - start;
    }

    @Override
    public String toString() {
        return "MotionDonePLC{" + super.toString() + " motion=" + this.motion.toString() + '}';
    }

    public MotionDone getStatusBusMessage() {
        return this.motion;
    }

    static {
        ByteBuffer data = ByteBuffer.allocate(1000);
        HallTransition hall = new HallTransition(CCSTimeStamp.currentTime(), 0, 0.0, false);
        HALL_TRANSITION_SIZE = MotionDonePLC.encodeHallTransition(data, hall);
        EncoderSample sample = new EncoderSample(CCSTimeStamp.currentTime(), 0.0);
        ENCODER_SAMPLE_SIZE = MotionDonePLC.encodeEncoderSample(data, sample);
    }
}

