/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.Controller;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.Reset;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.utilities.logging.Logger;

class RealActions
implements Actions {
    private static final Logger LOG = Logger.getLogger((String)RealActions.class.getName());
    private static final Alert SYNC_ALERT = new Alert("SYNC", "Status of tracking of controller state.");
    private final Controller control;
    private final StateMachine machine;
    private final Subsystem subsys;
    private final Publisher publish;

    public RealActions(Controller control, StateMachine machine, Subsystem subsys, Publisher publish) {
        this.control = control;
        this.machine = machine;
        this.subsys = subsys;
        this.publish = publish;
    }

    @Override
    public void cancelSyncTimer() {
        LOG.fine((Object)"{ACTION cancelSyncTimer()}");
        this.machine.cancelSyncTimer();
    }

    @Override
    public boolean isBadExposureTime(Duration exposureTime) {
        LOG.fine((Object)"{ACTION isBadExposure()}");
        return this.control.isBadExposureTime(exposureTime);
    }

    @Override
    public void lowerSyncAlert() {
        LOG.fine((Object)"{ACTION lowerSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.NOMINAL, "OK.");
    }

    @Override
    public boolean makePartialContact() {
        LOG.fine((Object)"{ACTION makePartialContact()}");
        return this.control.makePartialContact();
    }

    @Override
    public boolean makeFullContact() {
        LOG.fine((Object)"{ACTION makeFullContact()}");
        return this.control.makeFullContact();
    }

    @Override
    public void setPhysicalState(PhysicalState newState) {
        LOG.fine((Object)String.format("{ACTION setPhysicalState(%s)}", newState));
        this.machine.setPhysicalState(newState);
    }

    @Override
    public void raiseSyncAlert() {
        LOG.fine((Object)"{ACTION raiseSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.ALARM, "Lost track.");
    }

    @Override
    public boolean readyForCalibration() {
        LOG.fine((Object)"{ACTION readyForCalibration()}");
        return this.control.readyForCalibration();
    }

    @Override
    public void resetPLC() {
        LOG.fine((Object)"{ACTION resetPLC()}");
        this.control.relay(new Reset());
    }

    @Override
    public void relay(MsgToPLC eventMsg) {
        LOG.log(Level.FINE, "{ACTION relay({0}}", eventMsg.getClass());
        this.control.relay(eventMsg);
    }

    @Override
    public void saveCalib(CalibDone cal) {
        LOG.warn((Object)"{ACTION saveCalib() - not yet implemented.}");
    }

    @Override
    public void sendProfile(MotionDonePLC mot) {
        LOG.warn((Object)"{ACTION sendProfile().}");
        this.publish.publishMotionDone(mot.getStatusBusMessage());
    }

    @Override
    public void startFirstCentering() {
        LOG.fine((Object)"{ACTION startFirstCentering()}");
        this.control.startFirstCentering();
    }

    @Override
    public void startSecondCentering() {
        LOG.fine((Object)"{ACTION startSecondCentering(};}");
        this.control.startSecondCentering();
    }

    @Override
    public boolean shutterIsReady() {
        LOG.fine((Object)"{ACTION shutterIsReady()}");
        return this.control.shutterIsReady();
    }

    @Override
    public void startSyncTimer() {
        LOG.fine((Object)"{ACTION startSyncTimer()}");
        this.machine.startSyncTimer();
    }

    @Override
    public void terminateContact() {
        LOG.fine((Object)"{ACTION terminateContact()}");
        this.control.terminateContact();
    }
}

