/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.Maint;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MaintTest {
    @Test
    public void testTransitions() {
        Enabled dummyContext = (Enabled)Mockito.mock(Enabled.class);
        Actions mockActions = (Actions)Mockito.mock(Actions.class);
        Maint sm = new Maint(mockActions, dummyContext);
        sm.init();
        sm.changeAxisEnable((ChangeAxisEnable)Mockito.mock(ChangeAxisEnable.class));
        sm.clearAllFaults((ClearAllFaults)Mockito.mock(ClearAllFaults.class));
        sm.clearAxisFaults((ClearAxisFaults)Mockito.mock(ClearAxisFaults.class));
        sm.disableAllAxes((DisableAllAxes)Mockito.mock(DisableAllAxes.class));
        sm.enableAllAxes((EnableAllAxes)Mockito.mock(EnableAllAxes.class));
        sm.changeBrakeState(Axis.AXIS0, ChangeBrakeState.State.RELEASED);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        sm.moveAxisAbsolute((MoveAxisAbsolute)Mockito.mock(MoveAxisAbsolute.class));
        ((Actions)Mockito.verify((Object)mockActions)).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions)).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        MotionDonePLC md1 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(md1);
        ((Actions)Mockito.verify((Object)mockActions)).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        sm.moveAxisRelative((MoveAxisRelative)Mockito.mock(MoveAxisRelative.class));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        MotionDonePLC md2 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(md2);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        Mockito.when((Object)mockActions.readyForCalibration()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        sm.calibrate((Calibrate)Mockito.mock(Calibrate.class));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        sm.calibrate((Calibrate)Mockito.mock(Calibrate.class));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)5))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        sm.calibDone((CalibDone)Mockito.mock(CalibDone.class));
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)6))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        sm.gotoCenter();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)7))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        MotionDonePLC md3 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(md3);
        MotionDonePLC md4 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        sm.motionDone(md4);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CENTERED);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)8))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{dummyContext, md1, md2, md3, md4});
        InOrder order = Mockito.inOrder((Object[])new Object[]{mockActions});
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ChangeAxisEnablePLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ClearAllFaultsPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ClearAxisFaultsPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(DisableAllAxesPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(EnableAllAxesPLC.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ChangeBrakeState.class));
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(MoveAxisAbsolutePLC.class));
        ((Actions)order.verify((Object)mockActions)).sendProfile(md1);
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(MoveAxisRelativePLC.class));
        ((Actions)order.verify((Object)mockActions)).sendProfile(md2);
        ((Actions)order.verify((Object)mockActions)).relay((MsgToPLC)ArgumentMatchers.any(Calibrate.class));
        ((Actions)order.verify((Object)mockActions)).saveCalib((CalibDone)ArgumentMatchers.any(CalibDone.class));
        ((Actions)order.verify((Object)mockActions)).startFirstCentering();
        ((Actions)order.verify((Object)mockActions)).sendProfile(md3);
        ((Actions)order.verify((Object)mockActions)).startSecondCentering();
        ((Actions)order.verify((Object)mockActions)).sendProfile(md4);
        ((Actions)order.verify((Object)mockActions, Mockito.atLeast((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        order.verifyNoMoreInteractions();
    }
}

