/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.InSync;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class InSyncTest {
    @Test
    public void testTransitions() {
        Actions mockActions = (Actions)Mockito.mock(Actions.class);
        TopContext mockContext = (TopContext)Mockito.mock(TopContext.class);
        InSync sm = new InSync(mockActions, mockContext);
        Mockito.when((Object)mockContext.getPLCEnabled()).thenReturn((Object)true);
        sm.init();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((TopContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).getPLCEnabled();
        sm.disable();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OTHER);
        sm.enable();
        sm.disable();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OTHER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockActions});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockContext});
    }
}

