package org.lsst.ccs.subsystem.shutter.statemachine;

import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import java.util.logging.Logger;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.*;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * The state machine enters this state when the CCS subsystem and the shutter PLC
 * are out of sync, that is, the state of one didn't correspond with the state of the other.
 * Thread-safe.
 * @author tether
 */
class SyncError extends SimpleState<TopContext> {
    
    private static final Logger LOG = Logger.getLogger(SyncError.class.getName());

    /**
     * Saves the reference to the context object.
     * @param context The context object.
     * @throws NullPointerException if the context is null.
     */
    public SyncError(final TopContext context) {
        super(context);
    }
    
    @Override
    public Logger getLogger() {return LOG;}

    /** {@inheritDoc} Raises a SYNC alert with a severity of ALARM. */
    @Override
    public void entry() {
        logEntry(this);
        getContext().getActions().terminateContact();
        getContext().getActions().raiseSyncAlert();
        getContext().getActions().setPhysicalState(PhysicalState.OTHER);
    }

    /**
     * @return {@link PromptReply#ACCEPTED}
    */
    @Override
    public EventReply resync() {
        logEvent(this);
        getContext().makeTransition(getContext().getSynchronizingState(), null);
        return ACCEPTED;
    }

}
