package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEvent;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * State in which shutter operation is prohibited due to
 * a veto from hardware protection. Thread-safe.
 * @author tether
 */
class Disabled extends SimpleState<InSync> {
    
    private static final Logger LOG = Logger.getLogger(Disabled.class.getName());

    /**
     * Saves the reference to the context object.
     * @param context The context object.
     * @throws NullPointerException if the context is null.
     */
    public Disabled(final InSync context) {
        super(context);
    }
    
    @Override
    public Logger getLogger() {return LOG;}

    /** @return {@link PromptReply#ACCEPTED}  */
    @Override
    public EventReply enable() {
        logEvent(this);
        getContext().makeTransition(getContext().getEnabledState(), null);
        return ACCEPTED;
    }

}
