package org.lsst.ccs.subsystem.shutter.statemachine;

import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEntry;

/**
 * The state in which the shutter, in normal operating mode, is closing (only one blade set in motion).
 * Thread-safe.
 * @author tether
 */
class Closing extends SimpleState<Prod> {
    private static final Logger LOG = Logger.getLogger(Closing.class.getName());

    /**
     * Saves the context for this state.
     * @param context The context.
     * @throws NullPointerException if the context is null.
     */
    public Closing(Prod context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        logEntry(this);
        getContext().getActions().setPhysicalState(PhysicalState.CLOSING);
    }

    /**
     * {@inheritDoc} Publishes the motion profile on the status bus.
     * @return {@link PromptReply#ACCEPTED}
     */
    @Override
    public EventReply motionDone(final MotionDonePLC profileData) {
        logEntry(this);
        final Prod ctx = getContext();
        ctx.makeTransition(ctx.getClosedState(), 
                () -> ctx.getActions().sendProfile(profileData));
        return PromptReply.ACCEPTED;
    }
    
    
}
