package org.lsst.ccs.subsystem.shutter.statemachine;

import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import java.util.Objects;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEvent;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * The state in the second of two blade sets is being centered in prep for power-off.
 * Thread-safe.
 * @author tether
 */
class Centering2 extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Centering2.class.getName());

    /**
     * Saves the context for this state.
     * @param context The context.
     * @throws NullPointerException if the context is null.
     */
    public Centering2(final Maint context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    /** @return {@link PromptReply#ACCEPTED} */
    @Override
    public EventReply motionDone(final MotionDonePLC profileData) {
        logEvent(this);
        final Maint ctx = getContext();
        final Actions act = ctx.getActions();
        ctx.makeTransition(
            ctx.getStillState(),
            () -> {act.sendProfile(profileData); act.setPhysicalState(PhysicalState.CENTERED);}
        );
        return ACCEPTED;
    }

}
