package org.lsst.ccs.subsystem.shutter.statemachine;

import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEntry;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEvent;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * The state in the first of two blade sets is being centered in prep for power-off.
 * Thread-safe.
 * @author tether
 */
class Centering1 extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Centering1.class.getName());

    /**
     * Saves the context for this state.
     * @param context The context.
     * @throws NullPointerException if the context is null.
     */
    public Centering1(final Maint context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        logEntry(this);
        getContext().getActions().setPhysicalState(PhysicalState.ENG_MOVING);
    }

    /** @return {@link PromptReply#ACCEPTED} */
    @Override
    public EventReply motionDone(final MotionDonePLC profileData) {
        logEvent(this);
        final Maint ctx = getContext();
        ctx.makeTransition(
            ctx.getCentering2State(),
            () -> {ctx.getActions().sendProfile(profileData); ctx.getActions().startSecondCentering();});
        return ACCEPTED;
    }

}
