/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.common;

import java.util.Arrays;

public enum Axis {
    AXIS0("+X", 0, true),
    AXIS1("-X", 1, false);

    private final String name;
    private final int plcAxisNum;
    private final boolean plusXside;

    private Axis(String name, int plcAxisNum, boolean plusXside) {
        this.name = name;
        this.plcAxisNum = plcAxisNum;
        this.plusXside = plusXside;
    }

    public String getName() {
        return this.name;
    }

    public int getPLCAxisNum() {
        return this.plcAxisNum;
    }

    public static Axis fromName(String name) {
        return Arrays.stream(Axis.values()).filter(ax -> ax.getName().equals(name)).findFirst().get();
    }

    public static Axis fromAxisNum(int axnum) {
        return Arrays.stream(Axis.values()).filter(ax -> ax.getPLCAxisNum() == axnum).findFirst().get();
    }

    public boolean isPlusXSide() {
        return this.plusXside;
    }

    public static Axis getPlusXSide() {
        return AXIS0.isPlusXSide() ? AXIS0 : AXIS1;
    }

    public static Axis getMinusXSide() {
        return AXIS0.isPlusXSide() ? AXIS1 : AXIS0;
    }
}

