/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.HomeAxisPLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Maint;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Still
extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Still.class.getName());

    public Still(Maint context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public EventReply enableAllAxes(EnableAllAxes req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for enableAllAxes() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new EnableAllAxesPLC(req));
        }
        return reply;
    }

    @Override
    public EventReply disableAllAxes(DisableAllAxes req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for disableAllAxes() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new DisableAllAxesPLC(req));
        }
        return reply;
    }

    @Override
    public EventReply clearAxisFaults(ClearAxisFaults req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for clearAxisFaults() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new ClearAxisFaultsPLC(req));
        }
        return reply;
    }

    @Override
    public EventReply changeAxisEnable(ChangeAxisEnable req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for changeAxisEnable() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new ChangeAxisEnablePLC(req));
        }
        return reply;
    }

    @Override
    public EventReply changeBrakeState(Axis ax, ChangeBrakeState.State newState) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (ax == null || newState == null) {
            reply = new PromptReply("The axis or the new brake state is null.");
        } else {
            ((Maint)this.getContext()).getActions().relay(new ChangeBrakeState(ax, newState));
        }
        return reply;
    }

    @Override
    public EventReply clearAllFaults(ClearAllFaults req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for clearAllFaults() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.getActions().relay(new ClearAllFaultsPLC(req));
        }
        return reply;
    }

    @Override
    public EventReply moveAxisRelative(MoveAxisRelative req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for moveAxisRelative() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.makeTransition(ctx.getMovingState(), () -> ctx.getActions().relay(new MoveAxisRelativePLC(req)));
        }
        return reply;
    }

    @Override
    public EventReply moveAxisAbsolute(MoveAxisAbsolute req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for moveAxisAbsolute() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.makeTransition(ctx.getMovingState(), () -> ctx.getActions().relay(new MoveAxisAbsolutePLC(req)));
        }
        return reply;
    }

    @Override
    public EventReply homeAxis(HomeAxis req) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (req == null) {
            reply = new PromptReply("Null argument for homeAxis() event.");
        } else {
            Maint ctx = (Maint)this.getContext();
            ctx.makeTransition(ctx.getMovingState(), () -> ctx.getActions().relay(new HomeAxisPLC(req)));
        }
        return reply;
    }

    @Override
    public EventReply gotoCenter() {
        Logging.logEvent(this);
        Maint ctx = (Maint)this.getContext();
        ctx.makeTransition(ctx.getCentering1State(), () -> ctx.getActions().startFirstCentering());
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply calibrate(Calibrate calibParams) {
        PromptReply reply = PromptReply.ACCEPTED;
        Logging.logEvent(this);
        Maint ctx = (Maint)this.getContext();
        if (calibParams == null) {
            reply = new PromptReply("Null parameter for calibrate() event.");
        } else if (ctx.getActions().readyForCalibration()) {
            ctx.makeTransition(ctx.getCalibratingState(), () -> ctx.getActions().relay(calibParams));
        } else {
            reply = new PromptReply("Not ready for calibration. See the log.");
        }
        return reply;
    }
}

