/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Closed
extends SimpleState<Prod> {
    private static final Logger LOG = Logger.getLogger(Closed.class.getName());

    public Closed(Prod context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((Prod)this.getContext()).getActions().setPhysicalState(PhysicalState.CLOSED);
    }

    @Override
    public EventReply openShutter() {
        Logging.logEvent(this);
        ((Prod)this.getContext()).makeTransition(((Prod)this.getContext()).getOpeningState(), () -> ((Prod)this.getContext()).getActions().relay(new OpenShutter()));
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply takeExposure(Duration exposureTime) {
        Logging.logEvent(this);
        PromptReply reply = PromptReply.ACCEPTED;
        if (exposureTime == null) {
            reply = new PromptReply("The exposure Duration musn't be null");
        } else if (((Prod)this.getContext()).getActions().isBadExposureTime(exposureTime)) {
            reply = new PromptReply("The exposure time " + exposureTime + " is invalid.");
        } else {
            ((Prod)this.getContext()).makeTransition(((Prod)this.getContext()).getOpeningState(), () -> ((Prod)this.getContext()).getActions().relay(new TakeExposure(exposureTime)));
        }
        return reply;
    }
}

