/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Tools {
    private static final long OFFSET_FROM_TAI_TO_UNIX = 946684813000L;

    public static boolean getBoolean(ByteBuffer data) {
        return data.get() != 0;
    }

    public static void putBoolean(ByteBuffer data, boolean b) {
        data.put(b ? (byte)1 : 0);
    }

    public static CCSTimeStamp fromDcInstant(long dcNanos) {
        long dcMillis = (dcNanos + 163840L) / 1000000L;
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        Instant taiNow = now.getTAIInstant();
        Instant utcNow = now.getUTCInstant();
        long nleapMillis = Duration.between(utcNow, taiNow).toMillis();
        return CCSTimeStamp.currentTimeFromMillis((long)(dcMillis + 946684813000L - nleapMillis));
    }

    public static long toDcInstant(CCSTimeStamp stamp) {
        long unixMillis = stamp.getTAIInstant().toEpochMilli();
        return (unixMillis - 946684813000L) * 1000000L;
    }

    public static Duration fromDcDuration(long dcNanos) {
        return Duration.ofNanos(dcNanos);
    }

    public static long toDcDuration(Duration interval) {
        return interval.toNanos();
    }
}

