/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.plc.Tools;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class ShutterStatusPLC
extends MsgToCCS {
    final ShutterStatus status;

    public ShutterStatusPLC(int sequence, ShutterStatus status) {
        super(sequence);
        this.status = status;
    }

    public ShutterStatusPLC(ByteBuffer data) {
        super(data);
        int motionProfile = data.getInt();
        boolean isCalibrated = Tools.getBoolean(data);
        int smState = data.getInt();
        EnumMap<ShutterSide, ShutterStatus.AxisStatus> axes = new EnumMap<ShutterSide, ShutterStatus.AxisStatus>(ShutterSide.class);
        axes.put(ShutterSide.fromAxis(Axis.AXIS0), ShutterStatusPLC.decodeAxisStatus(data));
        axes.put(ShutterSide.fromAxis(Axis.AXIS1), ShutterStatusPLC.decodeAxisStatus(data));
        this.status = new ShutterStatus(motionProfile, isCalibrated, smState, axes);
    }

    private static ShutterStatus.AxisStatus decodeAxisStatus(ByteBuffer data) {
        double actPos = data.getDouble();
        double actVel = data.getDouble();
        double setAcc = data.getDouble();
        boolean enabled = Tools.getBoolean(data);
        boolean brakeSet = Tools.getBoolean(data);
        boolean lowLimit = Tools.getBoolean(data);
        boolean highLimit = Tools.getBoolean(data);
        boolean isHomed = Tools.getBoolean(data);
        int errorID = data.getInt();
        double motorTemp = data.getDouble();
        return new ShutterStatus.AxisStatus(actPos, actVel, setAcc, enabled, brakeSet, lowLimit, highLimit, isHomed, errorID, motorTemp);
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(this.status.getMotionProfile());
        Tools.putBoolean(data, this.status.isCalibrated());
        data.putInt(this.status.getSmState());
        for (Axis ax : Axis.values()) {
            ShutterStatusPLC.encodeAxisStatus(data, this.status.getAxisStatus(ShutterSide.fromAxis(ax)));
        }
    }

    private static void encodeAxisStatus(ByteBuffer data, ShutterStatus.AxisStatus status) {
        data.putDouble(status.getActPos());
        data.putDouble(status.getActVel());
        data.putDouble(status.getSetAcc());
        Tools.putBoolean(data, status.isEnabled());
        Tools.putBoolean(data, status.isBrakeSet());
        Tools.putBoolean(data, status.atLowLimit());
        Tools.putBoolean(data, status.atHighLimit());
        Tools.putBoolean(data, status.isHomed());
        data.putInt(status.getErrorID());
        data.putDouble(status.getMotorTemp());
    }

    public ShutterStatus getStatusBusMessage() {
        return this.status;
    }

    public int getMotionProfile() {
        return this.status.getMotionProfile();
    }

    public boolean isCalibrated() {
        return this.status.isCalibrated();
    }

    public int getSmState() {
        return this.status.getSmState();
    }

    public ShutterStatus.AxisStatus getAxisStatus(Axis ax) {
        return this.status.getAxisStatus(ShutterSide.fromAxis(ax));
    }

    @Override
    public String toString() {
        return "ShutterStatusPLC{" + super.toString() + " status=" + this.status.toString() + "}";
    }
}

