/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class SimulatedActions
implements Actions {
    private static final Logger LOG = Logger.getLogger((String)SimulatedActions.class.getName());
    private static final Alert SYNC_ALERT = new Alert("SYNC", "Status of tracking of controller state.");
    private final StateMachine machine;
    private final Subsystem subsys;
    private final Publisher publish;
    private final List<ShutterSide> movementCycle;
    private int icycle;
    private final Map<ShutterSide, SideInfo> sdinfo;

    public SimulatedActions(StateMachine machine, Subsystem subsys, Publisher publish) {
        this.machine = machine;
        this.subsys = subsys;
        this.publish = publish;
        this.icycle = 0;
        this.movementCycle = Arrays.asList(ShutterSide.PLUSX, ShutterSide.MINUSX, ShutterSide.MINUSX, ShutterSide.PLUSX);
        this.sdinfo = new EnumMap<ShutterSide, SideInfo>(ShutterSide.class);
        this.sdinfo.put(ShutterSide.PLUSX, new SideInfo(750.0, false));
        this.sdinfo.put(ShutterSide.MINUSX, new SideInfo(750.0, false));
    }

    @Override
    public void cancelSyncTimer() {
        LOG.info((Object)"{ACTION cancelSyncTimer()}");
    }

    @Override
    public boolean isBadExposureTime(Duration exposureTime) {
        LOG.info((Object)"{ACTION isBadExposure()}");
        return false;
    }

    @Override
    public void lowerSyncAlert() {
        LOG.info((Object)"{ACTION lowerSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.NOMINAL, "OK.");
    }

    @Override
    public boolean makePartialContact() {
        LOG.info((Object)"{ACTION makePartialContact()}");
        return true;
    }

    @Override
    public boolean makeFullContact() {
        LOG.info((Object)"{ACTION makeFullContact()}");
        return true;
    }

    @Override
    public void setPhysicalState(PhysicalState newState) {
        LOG.fine((Object)String.format("{ACTION setPhysicalState(%s)}", new Object[]{newState}));
        this.machine.setPhysicalState(newState);
    }

    @Override
    public void raiseSyncAlert() {
        LOG.info((Object)"{ACTION raiseSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.ALARM, "Lost track.");
    }

    @Override
    public boolean readyForCalibration() {
        LOG.info((Object)"{ACTION readyForCalibration()}");
        return true;
    }

    @Override
    public void resetPLC() {
        LOG.info((Object)"{ACTION resetPLC()}");
    }

    @Override
    public void relay(MsgToPLC eventMsg) {
        LOG.log(Level.INFO, "'{'ACTION relay({0})'}'", eventMsg.getClass());
        if (eventMsg instanceof OpenShutter) {
            this.machine.motionDone(new MotionDonePLC(1, null));
        } else if (eventMsg instanceof CloseShutter) {
            this.machine.motionDone(new MotionDonePLC(2, null));
        } else if (eventMsg instanceof TakeExposure) {
            this.machine.motionDone(new MotionDonePLC(3, null));
            this.machine.motionDone(new MotionDonePLC(4, null));
        } else if (eventMsg instanceof ChangeBrakeState) {
            boolean brakeOn;
            ChangeBrakeState ch = (ChangeBrakeState)eventMsg;
            ShutterSide side = ch.getAxis().isPlusXSide() ? ShutterSide.PLUSX : ShutterSide.MINUSX;
            this.sdinfo.get((Object)((Object)side)).brakeOn = brakeOn = ch.getState() == ChangeBrakeState.State.SET;
            this.sendStatus();
        }
    }

    @Override
    public void saveCalib(CalibDone cal) {
        LOG.info((Object)"{ACTION saveCalib() - not yet implemented.}");
    }

    @Override
    public void sendProfile(MotionDonePLC mot) {
        LOG.info((Object)"{ACTION sendProfile()}");
        this.sendStatus();
        ShutterSide nextToMove = this.movementCycle.get(this.icycle);
        this.icycle = (this.icycle + 1) % this.movementCycle.size();
        double startpos = this.sdinfo.get((Object)((Object)nextToMove)).position;
        double targpos = startpos < 1.0 ? 750.0 : 0.0;
        Duration dur = Duration.ofSeconds(1L);
        MotionDone motion = new MotionDone.Builder().side(nextToMove).startPosition(startpos).targetPosition(targpos).startTime(CCSTimeStamp.currentTime()).endPosition(targpos).targetDuration(dur).actualDuration(dur).addEncoderSample(new EncoderSample(CCSTimeStamp.currentTime(), 12345.0)).addHallTransition(new HallTransition(CCSTimeStamp.currentTime(), 321, 3.14159, true)).build();
        this.sdinfo.get((Object)((Object)nextToMove)).position = targpos;
        this.publish.publish(motion);
        this.sendStatus();
    }

    private void sendStatus() {
        EnumMap<ShutterSide, ShutterStatus.AxisStatus> axes = new EnumMap<ShutterSide, ShutterStatus.AxisStatus>(ShutterSide.class);
        for (ShutterSide side : ShutterSide.values()) {
            ShutterStatus.AxisStatus axstat = new ShutterStatus.AxisStatus(this.sdinfo.get((Object)((Object)side)).position, 0.0, 0.0, true, this.sdinfo.get((Object)((Object)side)).brakeOn, false, false, true, 0, 30.0);
            axes.put(side, axstat);
        }
        ShutterStatus status = new ShutterStatus(0, true, 0, axes);
        this.publish.updateShutterStatus(status);
    }

    @Override
    public void startFirstCentering() {
        LOG.info((Object)"{ACTION startFirstCentering()}");
    }

    @Override
    public void startSecondCentering() {
        LOG.info((Object)"{ACTION startSecondCentering(};}");
    }

    @Override
    public boolean shutterIsReady() {
        LOG.info((Object)"{ACTION shutterIsReady()}");
        return true;
    }

    @Override
    public void startSyncTimer() {
        LOG.info((Object)"{ACTION startSyncTimer()}");
    }

    @Override
    public void terminateContact() {
        LOG.info((Object)"{ACTION terminateContact()}");
    }

    private static final class SideInfo {
        double position;
        boolean brakeOn;

        SideInfo(double x, boolean y) {
            this.position = x;
            this.brakeOn = y;
        }
    }
}

