/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.ptp;

import java.nio.LongBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.lsst.ccs.drivers.ads.ADSDriver;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class PTPInfoReader {
    private static final String LOCAL_AMS_NETID = "192.168.10.80.1.1";
    private static final String REMOTE_AMS_NETID = "5.56.86.54.1.1";
    private static final String REMOTE_IP_ADDRESS = "192.168.10.40";
    private static final String VARIABLE_NAME = "tinfo";
    private static final int NUM_SAMPLES = 1000;
    private final ADSDriver driver = new ADSDriver("192.168.10.80.1.1");
    private final VariableHandle varHandle;

    PTPInfoReader() throws DriverException {
        this.driver.open(REMOTE_AMS_NETID, REMOTE_IP_ADDRESS);
        this.varHandle = this.driver.getVariableHandle(VARIABLE_NAME);
        this.driver.requestNotifications(this.varHandle, Duration.ZERO, Duration.ZERO, true);
    }

    public void close() {
        this.driver.close();
    }

    public TimeInfo getInfo() throws InterruptedException {
        Notification notice = this.driver.takeNotification();
        return new TimeInfo(notice.getData().asLongBuffer());
    }

    public static void main(String[] args) throws DriverException, InterruptedException {
        PTPInfoReader reader = new PTPInfoReader();
        Instant dcEpochUTC = Instant.parse("2000-01-01T00:00:00Z");
        CCSTimeStamp dcEpochCCS = CCSTimeStamp.currentTimeFromMillis((long)dcEpochUTC.toEpochMilli());
        long dcEpochTAI = dcEpochCCS.getTAIInstant().getEpochSecond() * 1000000000L + (long)dcEpochCCS.getTAIInstant().getNano();
        System.out.println("\"Local TAI time\",\"DC time\",\"DC to TC offset\",\"DC to ext offset\",\"EL6688 internal\",\"EL6688 external\"");
        try {
            reader.getInfo();
            while (true) {
                TimeInfo info = reader.getInfo();
                Instant now = CCSTimeStamp.currentTime().getTAIInstant();
                long taiNanos = (long)now.getNano() + now.getEpochSecond() * 1000000000L - dcEpochTAI;
                System.out.println(taiNanos + "," + info.toString());
            }
        }
        catch (Throwable throwable) {
            reader.close();
            throw throwable;
        }
    }

    public static class TimeInfo {
        public final long[] info = new long[5];

        public TimeInfo(LongBuffer buf) {
            buf.get(this.info);
        }

        public String toString() {
            return Arrays.stream(this.info).mapToObj(Long::toString).collect(Collectors.joining(","));
        }
    }
}

