package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEntry;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEvent;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * State in which shutter operation is prohibited due to
 * a veto from hardware protection. Thread-safe.
 * @author tether
 */
class Disabled extends SimpleState<InSync> {

    private static final Logger LOG = Logger.getLogger(Disabled.class.getName());

    /**
     * Saves the reference to the context object.
     * @param context The context object.
     * @throws NullPointerException if the context is null.
     */
    public Disabled(final InSync context) {
        super(context);
    }

    @Override
    public Logger getLogger() {return LOG;}

    @Override
    public void entry() {
        logEntry(this);
        getContext().getActions().setSoftwareState(SoftwareState.DISABLED);
    }

    @Override
    public void enable(final Channel<EventReply> chan) throws InterruptedException {
        logEvent(this);
        chan.write(ACCEPTED);
        getContext().makeTransition(getContext().getEnabledState(), null);
    }

}
