package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;

/**
 * Signals to the PLC to go through its reset sequence.
 * @author tether
 */
public class Reset extends MsgToPLC {
    
    final double maxStrokeSpeed;

    /** Constructs from scratch.
     * @param maxStrokeSpeed The maximum speed, in mm/sec, that a blade set will attain
     * during a stroke.
     */
    public Reset(final double maxStrokeSpeed) {
        super();
        this.maxStrokeSpeed = maxStrokeSpeed;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data Holds the PLC message data.
     */
    public Reset(final ByteBuffer data) {
        super(data);
        this.maxStrokeSpeed = data.getDouble();
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putDouble(maxStrokeSpeed);
    }

    public double getMaxStrokeSpeed() {return maxStrokeSpeed;}

    @Override
    public String toString() {
        return "Reset{" + super.toString()
                + " maxStrokeSpeed=" + Double.toString(maxStrokeSpeed)+ '}';
    }

}
