package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;

/**
 * Holds an Enable message sent from the PLC.
 * @author tether
 */
public class Enable extends MsgToCCS {

    /** Constructs from scratch.
     *  @param sequence A message sequence number.
     */
    public Enable(final int sequence) {super(sequence);}

    /**
     * Reads and converts the PLC form of the message.
     * @param data Holds the PLC message data.
     */
    public Enable(final ByteBuffer data) {
        super(data);
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
    }

    @Override
    public String toString() {
        return "Enable{" + super.toString() + '}';
    }

}
