package org.lsst.ccs.subsystem.shutter.plc;

/**
 * Names of several blade set positions of special importance. Associated with each position
 * is a key string used with configuration file maps.
 * @author tether
 */
public enum BladeSetPosition {
    /** The most retracted position possible without running into soft or hard motion limits. */
    HOME("home"),

    /** This close or closer to home and the blade set is considered fully retracted. */
    RETRACTED("retracted"),

    /** Move the blade set here to center it prior to shutting off the shutter. */
    CENTERED("centered"),

    /** As far or farther from home than this and the blade set is considered fully extended. */
    EXTENDED("extended");

    private final String key;

    BladeSetPosition(final String key) {this.key = key;}

    /**
     * Gets the associated map key.
     * @return The key string.
     */
    public String getKey() {return key;}
}
