/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProdTest {
    @Test
    public void testTransitions() throws InterruptedException {
        MotionDonePLC[] md = new MotionDonePLC[6];
        for (int i = 0; i < 6; ++i) {
            md[i] = new MotionDonePLC(i, null);
        }
        Enabled dummyContext = (Enabled)Mockito.mock(Enabled.class);
        Actions act = (Actions)Mockito.mock(Actions.class);
        Mockito.when((Object)act.isBadExposureTime(Duration.ofSeconds(3L))).thenReturn((Object)true);
        Prod sm = new Prod(act, dummyContext);
        DummyChannel chan = new DummyChannel();
        sm.init();
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CLOSED);
        sm.takeExposure(chan, Duration.ofSeconds(1L));
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OPENING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.OPENING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.motionDone(chan, md[0]);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OPENED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.OPENED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.timer(chan);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CLOSING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)4))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CLOSING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)4))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.motionDone(chan, md[1]);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)5))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)5))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.takeExposure(chan, Duration.ofSeconds(2L));
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OPENING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)6))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.OPENING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)6))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.timer(chan);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.TRAVELING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)7))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.TRAVELING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)7))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.motionDone(chan, md[2]);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.CLOSING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)8))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.CLOSING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)8))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.motionDone(chan, md[3]);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)9))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)9))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.takeExposure(chan, Duration.ofSeconds(3L));
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)9))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)9))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.openShutter(chan);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.OPENING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)10))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.OPENING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)10))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.motionDone(chan, md[4]);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OPENED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)11))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.OPENED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)11))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.closeShutter(chan);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.CLOSING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)12))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.CLOSING);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)12))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.motionDone(chan, md[5]);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)4))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)13))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)4))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)13))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{dummyContext});
        InOrder order = Mockito.inOrder((Object[])new Object[]{act});
        ((Actions)order.verify((Object)act)).isBadExposureTime(Duration.ofSeconds(1L));
        ((Actions)order.verify((Object)act)).relay((MsgToPLC)ArgumentMatchers.any(TakeExposure.class));
        ((Actions)order.verify((Object)act)).sendProfile(md[0]);
        ((Actions)order.verify((Object)act)).sendProfile(md[1]);
        ((Actions)order.verify((Object)act)).isBadExposureTime(Duration.ofSeconds(2L));
        ((Actions)order.verify((Object)act)).relay((MsgToPLC)ArgumentMatchers.any(TakeExposure.class));
        ((Actions)order.verify((Object)act)).sendProfile(md[2]);
        ((Actions)order.verify((Object)act)).sendProfile(md[3]);
        ((Actions)order.verify((Object)act)).isBadExposureTime(Duration.ofSeconds(3L));
        ((Actions)order.verify((Object)act)).relay((MsgToPLC)ArgumentMatchers.any(OpenShutter.class));
        ((Actions)order.verify((Object)act)).sendProfile(md[4]);
        ((Actions)order.verify((Object)act)).relay((MsgToPLC)ArgumentMatchers.any(CloseShutter.class));
        ((Actions)order.verify((Object)act)).sendProfile(md[5]);
        ((Actions)order.verify((Object)act, Mockito.atLeast((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)order.verify((Object)act, Mockito.atLeast((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        order.verifyNoMoreInteractions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{act});
    }
}

