package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.concurrent.SynchronousQueue;

/**
 * A message channel that is fully synchronous and fair. A writing task will block until another task reads
 * from the channel. A reading task will block until another task writes to the channel.
 * There is no buffering of messages. Tasks awaiting access are awakened in FIFO order (fair).
 * @author tether
 */
public class SynchronousChannel<T> implements Channel<T> {

    private SynchronousQueue<T> sync;

    public SynchronousChannel() {
        this.sync = new SynchronousQueue<>(true /* fair */);
    }

    @Override
    public void write(T msg) throws InterruptedException {
        sync.put(msg);
    }

    @Override
    public T read() throws InterruptedException {
        return sync.take();
    }



}
