package org.lsst.ccs.subsystem.shutter.statemachine;

import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEntry;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEvent;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * The maint-mode state in which a single blade set is moving according to a specific motion command.
 * Thread-safe.
 * @author tether
 */
class Moving extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Moving.class.getName());

    /**
     * Saves the context for this state.
     * @param context The context.
     * @throws NullPointerException if the context is null.
     */
    public Moving(Maint context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        logEntry(this);
        getContext().getActions().setSoftwareState(SoftwareState.MOVING);
        getContext().getActions().setPhysicalState(PhysicalState.ENG_MOVING);
    }

    @Override
    public void motionDone(final Channel<EventReply> chan, final MotionDonePLC profileData) throws InterruptedException {
        logEvent(this);
        chan.write(ACCEPTED);
        final Maint ctx = getContext();
        ctx.makeTransition(
            ctx.getStillState(),
            () -> {ctx.getActions().setPhysicalState(PhysicalState.OTHER);
                   ctx.getActions().sendProfile(profileData);});
    }

}
