package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.concurrent.TimeoutException;

/**
 * Response to an event, returned by event methods in states and contexts. 
 * @author tether
 */
public interface EventReply {

    /**
     * Returns an event reply for which {@code wasAccepted()} returns {@code true} and does not block.
     * @return The reply instance.
     */
    static EventReply accepted() {return PromptReply.ACCEPTED;}

    /**
     * Gets a boolean flag, blocking if need be, which tells whether an event was accepted.
     * @param timeout How long to wait for the decision.
     * @return true if the event was accepted, false if timeout or event was rejected.
     * @see #getMessage()
     * @throws InterruptedException if interrupted.
     * @throws TimeoutException if the wait times out.
     */
    boolean wasAccepted(Duration timeout) throws InterruptedException, TimeoutException;

    /** Gets a short string describing the acceptance or rejection.
     * @return The string.
     * @throws InterruptedException
     * @throws IllegalStateException if {@code wasAccepted()} wasn't called or threw an exception.
     * @see #wasAccepted() 
     */
    String getMessage() throws InterruptedException;
}
