package org.lsst.ccs.subsystem.shutter;

import org.lsst.ccs.bus.data.Alert;

/**
 * All the alerts that this subsystem can raise.
 * @author tether
 */
public class Alerts {

    /**
     * Raised if the PLC state machine and the subsystem state machine appear to
     * have gotten out of sync. 
     */
    public final static Alert SYNC = new Alert("SYNC", "Status of tracking of controller state.");

    /**
     * Raised if the shutter controller sends an explicit error message to the subsystem.
     */
    public final static Alert PLC = new Alert("PLC", "Notice of errors from shutter controller.");

    /**
     * Raised if no messages have arrived from the shutter controller within a certain period.
     */
    public final static Alert WATCHDOG = new Alert("WATCHDOG", "PLC message rate monitor.");

    /**
     * Raised if the Hall data from the last motion indicate a significant deviation
     * from the predicted motion.
     */
    public final static Alert MOTION = new Alert("MOTION", "Check of motion profile using Hall data.");
    
    /**
     * Raised if some problem has been observed with the motors. For example 
     * temperature out of the safe operating range.
     * 
     */
    public final static Alert MOTOR = new Alert("MOTOR", "A problem with the motors.");
    
    /**
     * Raised if the subsystem has been given the stopAllMotion() command while in Prod.
     */
    public final static Alert STOP_CMD = new Alert("STOP_CMD",
        "Received the stopAllMotion() command while in the Prod superstate.");

}
