/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class TopContextTest {
    @Test
    public void testTransitions() throws InterruptedException {
        TopContext sm = new TopContext((Actions)Mockito.mock(Actions.class));
        Actions act = sm.getActions();
        Channel chan = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)act.makePartialContact()).thenReturn((Object)true);
        Mockito.when((Object)act.makeFullContact()).thenReturn((Object)true);
        sm.init();
        sm.plcIsDisabled(chan);
        sm.ignored(chan, null);
        sm.resync(chan);
        sm.plcIsEnabled(chan);
        sm.contactLost(chan);
        sm.resync(chan);
        sm.syncTimeout(chan);
        InOrder order = Mockito.inOrder((Object[])new Object[]{act});
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNCHRONIZING);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).startSyncTimer();
        ((Actions)order.verify((Object)act)).cancelSyncTimer();
        ((Actions)order.verify((Object)act)).lowerSyncAlert();
        ((Actions)order.verify((Object)act)).makeFullContact();
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNC_ERROR);
        ((Actions)order.verify((Object)act)).terminateContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert();
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNCHRONIZING);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).startSyncTimer();
        ((Actions)order.verify((Object)act)).cancelSyncTimer();
        ((Actions)order.verify((Object)act)).lowerSyncAlert();
        ((Actions)order.verify((Object)act)).makeFullContact();
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNC_ERROR);
        ((Actions)order.verify((Object)act)).terminateContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert();
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNCHRONIZING);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).startSyncTimer();
        ((Actions)order.verify((Object)act)).cancelSyncTimer();
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNC_ERROR);
        ((Actions)order.verify((Object)act)).terminateContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert();
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        order.verifyNoMoreInteractions();
    }

    @Test
    public void testContactFailure() throws InterruptedException {
        TopContext sm = new TopContext((Actions)Mockito.mock(Actions.class));
        Actions act = sm.getActions();
        Channel chan = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)act.makePartialContact()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Mockito.when((Object)act.makeFullContact()).thenReturn((Object)false);
        sm.init();
        sm.plcIsDisabled(chan);
        sm.contactLost(chan);
        sm.resync(chan);
        sm.plcIsEnabled(chan);
        sm.contactLost(chan);
        InOrder order = Mockito.inOrder((Object[])new Object[]{act});
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).lowerSyncAlert();
        ((Actions)order.verify((Object)act)).raiseSyncAlert();
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).lowerSyncAlert();
        ((Actions)order.verify((Object)act)).makeFullContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert();
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        order.verifyNoMoreInteractions();
    }
}

