package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;

/**
 * Holds an Ignored message from the PLC.
 * @author tether
 */
public class Ignored  extends MsgToCCS {

    /**
     * The set of possible reasons for the PLC sending the Ignored message.
     */
    public static enum Reason {WRONG_MESSAGE_SET_VERSION, WRONG_STATE};

    private Reason reason;

    /** Constructs from scratch.
     * @param sequence A message sequence number.
     * @param reason The reason why the PLC code ignored an event message.
     */
    public Ignored(final int sequence, final Reason reason) {super(sequence); this.reason = reason;}

    /**
     * Reads and converts the PLC form of the message.
     * @param data Holds the PLC message data.
     */
    public Ignored(final ByteBuffer data) {
        super(data);
        this.reason = Reason.values()[data.getInt()];
    }

    /**
     * Gets the reason why the PLC ignored one of out messages.
     * @return The reason enumerator.
     * @see Reason
     */
    public Reason getReason() {return reason;}

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt(reason.ordinal());
    }

    @Override
    public String toString() {
        return "Ignored{" + super.toString() + " reason=" + reason + '}';
    }

}
